/**
 * @description 按照需要写入 必要可以注入全局
 */

interface enumObj {
  key: string
  value: number
}

/**
 * @description 将枚举转为数组
 * @param objEnum 枚举对象
 * @returns 转化后的数组
 */
export function formatEnum(objEnum: any): Array<enumObj> {
  const array: Array<enumObj> = new Array<enumObj>()
  for (const key in objEnum) {
    if (!isNaNModified(key)) continue
    const tempEnumObj: enumObj = {
      key,
      value: objEnum[key] as number
    }
    array.push(tempEnumObj)
  }
  return array
}

export function isNaNModified(inputStr: string) {
  const numericRepr = parseFloat(inputStr)
  return isNaN(numericRepr) || numericRepr.toString().length != inputStr.length
}
