/**
 * 验证工具类
 */

/* 合法uri*/
export function validateURL(textval: string) {
	const urlregex =
		/^(https?|ftp):\/\/([a-zA-Z0-9.-]+(:[a-zA-Z0-9.&%$-]+)*@)*((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]?)(\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])){3}|([a-zA-Z0-9-]+\.)*[a-zA-Z0-9-]+\.(com|edu|gov|int|mil|net|org|biz|arpa|info|name|pro|aero|coop|museum|[a-zA-Z]{2}))(:[0-9]+)*(\/($|[a-zA-Z0-9.,?'\\+&%$#=~_-]+))*$/
	return urlregex.test(textval)
}

/* 小写字母*/
export function validateLowerCase(str: string) {
	const reg = /^[a-z]+$/
	return reg.test(str)
}

/* 大写字母*/
export function validateUpperCase(str: string) {
	const reg = /^[A-Z]+$/
	return reg.test(str)
}

/* 大小写字母*/
export function validatAlphabets(str: string) {
	const reg = /^[A-Za-z]+$/
	return reg.test(str)
}

/** 比对数组是否相同 */
export function compareArray(arrA: any[], arrB: any[]) {
	let isSame = true
	if (arrA.length !== arrB.length) {
		return false
	} else {
		arrA.some((el, idx) => {
			if (el !== arrB[idx]) {
				isSame = false
				return true
			}
		})
	}
	return isSame
}
