//请求教育接口
let host = ''
if (process.env.NODE_ENV === "development") {
	//host = 'https://jjswapi.oytour.com/api'
	// host = 'http://192.168.10.206:5004/api'
	host = 'http://192.168.10.128:8800/api'
} else {
	host = 'https://jjswapi.oytour.com/api'
}
import Toast from '../wxcomponents/vant/toast/toast';
let request = (param) => {
	return new Promise((resolve, reject) => {
		let token = uni.getStorageSync('userInfo').Token;
		uni.request({
			url: host + param.url,
			method: param.method || "Post",
			header: param.header || {
				'content-type': "application/json",
				'Authorization': token || ""
			},
			data: {
				Msg: param.data,
			},
			success: res => {
				if (res.data.Code === 1) {
					resolve(res.data)
				} else {
					if (res.data.Code==10001 || res.data.Code == 10000) {
						if(!uni.getStorageSync('erpUserInfo')){
							console.log('in....')
							uni.showToast({
								title: "用户凭证失效,请重新授权",
								duration: 2000,
								icon: "none",
							});
							uni.removeStorageSync('userInfo');
							uni.reLaunch({
								url:"/pages/login/login"
							})
							reject()
						}else{
							resolve(res.data)
						}
					}else{
						let shields=['手机号码登录失败、跳转至账号登录']
						if(shields.indexOf(res.data.Message)==-1){
							uni.showToast({
								title: res.data.Message,
								duration: 2000,
								icon: "none",
								success() {
									if(res.data.Code === 0){
										resolve(res.data)
									}else{
										reject()
									}
								}
							});
						}else{
							if(res.data.Code === 0){
								resolve(res.data)
							}else{
								reject()
							}
						}
					}
					
				}
			},
			fail: (err) => {
				console.warn("fail:" + JSON.stringify(err));
				uni.showToast({
					title: '网络请求失败',
					duration: 2000,
					icon: "error",
				});
				reject()
			}
		});
	})
}
export default request
