/*
 * uCharts (R)
 * 高性能跨平台图表库，支持H5、APP、小程序（微信/支付宝/百度/头条/QQ/360/快手）、Vue、Taro等支持canvas的框架平台
 * Copyright (C) 2021 QIUN (R) 秋云 https://www.ucharts.cn All rights reserved.
 * Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
 * 复制使用请保留本段注释，感谢支持开源！
 * 
 * uCharts (R) 官方网站
 * https://www.uCharts.cn
 * 
 * 开源地址:
 * https://gitee.com/uCharts/uCharts
 * 
 * uni-app插件市场地址：
 * http://ext.dcloud.net.cn/plugin?id=271
 * 
 */
"use strict";var config={version:"v2.4.3-20220505",yAxisWidth:15,xAxisHeight:22,xAxisTextPadding:3,padding:[10,10,10,10],pixelRatio:1,rotate:false,fontSize:13,fontColor:"#666666",dataPointShape:["circle","circle","circle","circle"],color:["#1890FF","#91CB74","#FAC858","#EE6666","#73C0DE","#3CA272","#FC8452","#9A60B4","#ea7ccc"],linearColor:["#0EE2F8","#2BDCA8","#FA7D8D","#EB88E2","#2AE3A0","#0EE2F8","#EB88E2","#6773E3","#F78A85"],pieChartLinePadding:15,pieChartTextPadding:5,titleFontSize:20,subtitleFontSize:15,toolTipPadding:3,toolTipBackground:"#000000",toolTipOpacity:.7,toolTipLineHeight:20,radarLabelTextMargin:13};var assign=function(e,...t){if(e==null){throw new TypeError("[uCharts] Cannot convert undefined or null to object")}if(!t||t.length<=0){return e}function i(e,a){for(let t in a){e[t]=e[t]&&e[t].toString()==="[object Object]"?i(e[t],a[t]):e[t]=a[t]}return e}t.forEach(t=>{e=i(e,t)});return e};var util={toFixed:function t(e,a){a=a||2;if(this.isFloat(e)){e=e.toFixed(a)}return e},isFloat:function t(e){return e%1!==0},approximatelyEqual:function t(e,a){return Math.abs(e-a)<1e-10},isSameSign:function t(e,a){return Math.abs(e)===e&&Math.abs(a)===a||Math.abs(e)!==e&&Math.abs(a)!==a},isSameXCoordinateArea:function t(e,a){return this.isSameSign(e.x,a.x)},isCollision:function t(e,a){e.end={};e.end.x=e.start.x+e.width;e.end.y=e.start.y-e.height;a.end={};a.end.x=a.start.x+a.width;a.end.y=a.start.y-a.height;var i=a.start.x>e.end.x||a.end.x<e.start.x||a.end.y>e.start.y||a.start.y<e.end.y;return!i}};function getH5Offset(t){t.mp={changedTouches:[]};t.mp.changedTouches.push({x:t.offsetX,y:t.offsetY});return t}function hexToRgb(t,e){var a=/^#?([a-f\d])([a-f\d])([a-f\d])$/i;var i=t.replace(a,function(t,e,a,i){return e+e+a+a+i+i});var r=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(i);var o=parseInt(r[1],16);var n=parseInt(r[2],16);var l=parseInt(r[3],16);return"rgba("+o+","+n+","+l+","+e+")"}function findRange(t,e,a){if(isNaN(t)){throw new Error("[uCharts] series数据需为Number格式")}a=a||10;e=e?e:"upper";var i=1;while(a<1){a*=10;i*=10}if(e==="upper"){t=Math.ceil(t*i)}else{t=Math.floor(t*i)}while(t%a!==0){if(e==="upper"){if(t==t+1){break}t++}else{t--}}return t/i}function calCandleMA(o,t,e,n){let a=[];for(let r=0;r<o.length;r++){let i={data:[],name:t[r],color:e[r]};for(let a=0,t=n.length;a<t;a++){if(a<o[r]){i.data.push(null);continue}let e=0;for(let t=0;t<o[r];t++){e+=n[a-t][1]}i.data.push(+(e/o[r]).toFixed(3))}a.push(i)}return a}function calValidDistance(t,e,a,i,r){var o=r.width-r.area[1]-r.area[3];var n=a.eachSpacing*(r.chartData.xAxisData.xAxisPoints.length-1);if(r.type=="mount"&&r.extra&&r.extra.mount&&r.extra.mount.widthRatio&&r.extra.mount.widthRatio>1){if(r.extra.mount.widthRatio>2)r.extra.mount.widthRatio=2;n+=(r.extra.mount.widthRatio-1)*a.eachSpacing}var l=e;if(e>=0){l=0;t.uevent.trigger("scrollLeft");t.scrollOption.position="left";r.xAxis.scrollPosition="left"}else if(Math.abs(e)>=n-o){l=o-n;t.uevent.trigger("scrollRight");t.scrollOption.position="right";r.xAxis.scrollPosition="right"}else{t.scrollOption.position=e;r.xAxis.scrollPosition=e}return l}function isInAngleRange(t,e,a){function i(t){while(t<0){t+=2*Math.PI}while(t>2*Math.PI){t-=2*Math.PI}return t}t=i(t);e=i(e);a=i(a);if(e>a){a+=2*Math.PI;if(t<e){t+=2*Math.PI}}return t>=e&&t<=a}function createCurveControlPoints(t,e){function a(t,e){if(t[e-1]&&t[e+1]){return t[e].y>=Math.max(t[e-1].y,t[e+1].y)||t[e].y<=Math.min(t[e-1].y,t[e+1].y)}else{return false}}function c(t,e){if(t[e-1]&&t[e+1]){return t[e].x>=Math.max(t[e-1].x,t[e+1].x)||t[e].x<=Math.min(t[e-1].x,t[e+1].x)}else{return false}}var i=.2;var r=.2;var o=null;var n=null;var l=null;var s=null;if(e<1){o=t[0].x+(t[1].x-t[0].x)*i;n=t[0].y+(t[1].y-t[0].y)*i}else{o=t[e].x+(t[e+1].x-t[e-1].x)*i;n=t[e].y+(t[e+1].y-t[e-1].y)*i}if(e>t.length-3){var h=t.length-1;l=t[h].x-(t[h].x-t[h-1].x)*r;s=t[h].y-(t[h].y-t[h-1].y)*r}else{l=t[e+1].x-(t[e+2].x-t[e].x)*r;s=t[e+1].y-(t[e+2].y-t[e].y)*r}if(a(t,e+1)){s=t[e+1].y}if(a(t,e)){n=t[e].y}if(c(t,e+1)){l=t[e+1].x}if(c(t,e)){o=t[e].x}if(n>=Math.max(t[e].y,t[e+1].y)||n<=Math.min(t[e].y,t[e+1].y)){n=t[e].y}if(s>=Math.max(t[e].y,t[e+1].y)||s<=Math.min(t[e].y,t[e+1].y)){s=t[e+1].y}if(o>=Math.max(t[e].x,t[e+1].x)||o<=Math.min(t[e].x,t[e+1].x)){o=t[e].x}if(l>=Math.max(t[e].x,t[e+1].x)||l<=Math.min(t[e].x,t[e+1].x)){l=t[e+1].x}return{ctrA:{x:o,y:n},ctrB:{x:l,y:s}}}function convertCoordinateOrigin(t,e,a){return{x:a.x+t,y:a.y-e}}function avoidCollision(t,e){if(e){while(util.isCollision(t,e)){if(t.start.x>0){t.start.y--}else if(t.start.x<0){t.start.y++}else{if(t.start.y>0){t.start.y++}else{t.start.y--}}}}return t}function fixPieSeries(e,a,t){let i=[];if(e.length>0&&e[0].data.constructor.toString().indexOf("Array")>-1){a._pieSeries_=e;let t=e[0].data;for(var r=0;r<t.length;r++){t[r].formatter=e[0].formatter;t[r].data=t[r].value;i.push(t[r])}a.series=i}else{i=e}return i}function fillSeries(e,a,i){var r=0;for(var o=0;o<e.length;o++){let t=e[o];if(!t.color){t.color=i.color[r];r=(r+1)%i.color.length}if(!t.linearIndex){t.linearIndex=o}if(!t.index){t.index=0}if(!t.type){t.type=a.type}if(typeof t.show=="undefined"){t.show=true}if(!t.type){t.type=a.type}if(!t.pointShape){t.pointShape="circle"}if(!t.legendShape){switch(t.type){case"line":t.legendShape="line";break;case"column":case"bar":t.legendShape="rect";break;case"area":case"mount":t.legendShape="triangle";break;default:t.legendShape="circle"}}}return e}function fillCustomColor(t,e,a,i){var r=e||[];if(t=="custom"&&r.length==0){r=i.linearColor}if(t=="custom"&&r.length<a.length){let t=a.length-r.length;for(var o=0;o<t;o++){r.push(i.linearColor[(o+1)%i.linearColor.length])}}return r}function getDataRange(t,e){var a=0;var i=e-t;if(i>=1e4){a=1e3}else if(i>=1e3){a=100}else if(i>=100){a=10}else if(i>=10){a=5}else if(i>=1){a=1}else if(i>=.1){a=.1}else if(i>=.01){a=.01}else if(i>=.001){a=.001}else if(i>=1e-4){a=1e-4}else if(i>=1e-5){a=1e-5}else{a=1e-6}return{minRange:findRange(t,"lower",a),maxRange:findRange(e,"upper",a)}}function measureText(a,t,e){var i=0;a=String(a);e=false;if(e!==false&&e!==undefined&&e.setFontSize&&e.measureText){e.setFontSize(t);return e.measureText(a).width}else{var a=a.split("");for(let e=0;e<a.length;e++){let t=a[e];if(/[a-zA-Z]/.test(t)){i+=7}else if(/[0-9]/.test(t)){i+=5.5}else if(/\./.test(t)){i+=2.7}else if(/-/.test(t)){i+=3.25}else if(/:/.test(t)){i+=2.5}else if(/[\u4e00-\u9fa5]/.test(t)){i+=10}else if(/\(|\)/.test(t)){i+=3.73}else if(/\s/.test(t)){i+=2.5}else if(/%/.test(t)){i+=8}else{i+=10}}return i*t/10}}function dataCombine(t){return t.reduce(function(t,e){return(t.data?t.data:t).concat(e.data)},[])}function dataCombineStack(t,e){var a=new Array(e);for(var i=0;i<a.length;i++){a[i]=0}for(var r=0;r<t.length;r++){for(var i=0;i<a.length;i++){a[i]+=t[r].data[i]}}return t.reduce(function(t,e){return(t.data?t.data:t).concat(e.data).concat(a)},[])}function getTouches(t,e,a){let i,r;if(t.clientX){if(e.rotate){r=e.height-t.clientX*e.pix;i=(t.pageY-a.currentTarget.offsetTop-e.height/e.pix/2*(e.pix-1))*e.pix}else{i=t.clientX*e.pix;r=(t.pageY-a.currentTarget.offsetTop-e.height/e.pix/2*(e.pix-1))*e.pix}}else{if(e.rotate){r=e.height-t.x*e.pix;i=t.y*e.pix}else{i=t.x*e.pix;r=t.y*e.pix}}return{x:i,y:r}}function getSeriesDataItem(e,i,a){var r=[];var o=[];var n=i.constructor.toString().indexOf("Array")>-1;if(n){let t=filterSeries(e);for(var l=0;l<a.length;l++){o.push(t[a[l]])}}else{o=e}for(let t=0;t<o.length;t++){let e=o[t];let a=-1;if(n){a=i[t]}else{a=i}if(e.data[a]!==null&&typeof e.data[a]!=="undefined"&&e.show){let t={};t.color=e.color;t.type=e.type;t.style=e.style;t.pointShape=e.pointShape;t.disableLegend=e.disableLegend;t.name=e.name;t.show=e.show;t.data=e.formatter?e.formatter(e.data[a]):e.data[a];r.push(t)}}return r}function getMaxTextListLength(t,e,a){var i=t.map(function(t){return measureText(t,e,a)});return Math.max.apply(null,i)}function getRadarCoordinateSeries(t){var e=2*Math.PI/t;var a=[];for(var i=0;i<t;i++){a.push(e*i)}return a.map(function(t){return-1*t+Math.PI/2})}function getToolTipData(t,a,i,r,o){var n=arguments.length>5&&arguments[5]!==undefined?arguments[5]:{};var l=a.chartData.calPoints?a.chartData.calPoints:[];let s={};if(r.length>0){let e=[];for(let t=0;t<r.length;t++){e.push(l[r[t]])}s=e[0][i[0]]}else{for(let t=0;t<l.length;t++){if(l[t][i]){s=l[t][i];break}}}var e=t.map(function(t){let e=null;if(a.categories&&a.categories.length>0){e=o[i]}return{text:n.formatter?n.formatter(t,e,i,a):t.name+": "+t.data,color:t.color}});var h={x:Math.round(s.x),y:Math.round(s.y)};return{textList:e,offset:h}}function getMixToolTipData(t,e,a,i){var r=arguments.length>4&&arguments[4]!==undefined?arguments[4]:{};var o=e.chartData.xAxisPoints[a]+e.chartData.eachSpacing/2;var n=t.map(function(t){return{text:r.formatter?r.formatter(t,i[a],a,e):t.name+": "+t.data,color:t.color,disableLegend:t.disableLegend?true:false}});n=n.filter(function(t){if(t.disableLegend!==true){return t}});var l={x:Math.round(o),y:0};return{textList:n,offset:l}}function getCandleToolTipData(o,e,r,n,d,t){var x=arguments.length>6&&arguments[6]!==undefined?arguments[6]:{};var a=r.chartData.calPoints;let l=t.color.upFill;let s=t.color.downFill;let h=[l,l,s,l];var c=[];e.map(function(t){if(n==0){if(t.data[1]-t.data[0]<0){h[1]=s}else{h[1]=l}}else{if(t.data[0]<o[n-1][1]){h[0]=s}if(t.data[1]<t.data[0]){h[1]=s}if(t.data[2]>o[n-1][1]){h[2]=l}if(t.data[3]<o[n-1][1]){h[3]=s}}let e={text:"开盘："+t.data[0],color:h[0]};let a={text:"收盘："+t.data[1],color:h[1]};let i={text:"最低："+t.data[2],color:h[2]};let r={text:"最高："+t.data[3],color:h[3]};c.push(e,a,i,r)});var i=[];var f={x:0,y:0};for(let e=0;e<a.length;e++){let t=a[e];if(typeof t[n]!=="undefined"&&t[n]!==null){i.push(t[n])}}f.x=Math.round(i[0][0].x);return{textList:c,offset:f}}function filterSeries(e){let a=[];for(let t=0;t<e.length;t++){if(e[t].show==true){a.push(e[t])}}return a}function findCurrentIndex(o,n,e,t){var a=arguments.length>4&&arguments[4]!==undefined?arguments[4]:0;var l={index:-1,group:[]};var i=e.chartData.eachSpacing/2;let r=[];if(n&&n.length>0){if(!e.categories){i=0}else{for(let t=1;t<e.chartData.xAxisPoints.length;t++){r.push(e.chartData.xAxisPoints[t]-i)}if((e.type=="line"||e.type=="area")&&e.xAxis.boundaryGap=="justify"){r=e.chartData.xAxisPoints}}if(isInExactChartArea(o,e,t)){if(!e.categories){let a=Array(n.length);for(let e=0;e<n.length;e++){a[e]=Array(n[e].length);for(let t=0;t<n[e].length;t++){a[e][t]=Math.abs(n[e][t].x-o.x)}}let e=Array(a.length);let i=Array(a.length);for(let t=0;t<a.length;t++){e[t]=Math.min.apply(null,a[t]);i[t]=a[t].indexOf(e[t])}let r=Math.min.apply(null,e);l.index=[];for(let t=0;t<e.length;t++){if(e[t]==r){l.group.push(t);l.index.push(i[t])}}}else{r.forEach(function(t,e){if(o.x+a+i>t){l.index=e}})}}}return l}function findBarChartCurrentIndex(a,t,e,i){var r=arguments.length>4&&arguments[4]!==undefined?arguments[4]:0;var o={index:-1,group:[]};var n=e.chartData.eachSpacing/2;let l=e.chartData.yAxisPoints;if(t&&t.length>0){if(isInExactChartArea(a,e,i)){l.forEach(function(t,e){if(a.y+r+n>t){o.index=e}})}}return o}function findLegendIndex(o,t,e){let n=-1;let l=0;if(isInExactLegendArea(o,t.area)){let i=t.points;let r=-1;for(let t=0,e=i.length;t<e;t++){let a=i[t];for(let e=0;e<a.length;e++){r+=1;let t=a[e]["area"];if(t&&o.x>t[0]-l&&o.x<t[2]+l&&o.y>t[1]-l&&o.y<t[3]+l){n=r;break}}}return n}return n}function isInExactLegendArea(t,e){return t.x>e.start.x&&t.x<e.end.x&&t.y>e.start.y&&t.y<e.end.y}function isInExactChartArea(t,e,a){return t.x<=e.width-e.area[1]+10&&t.x>=e.area[3]-10&&t.y>=e.area[0]&&t.y<=e.height-e.area[2]}function findRadarChartCurrentIndex(t,e,a){var r=2*Math.PI/a;var o=-1;if(isInExactPieChartArea(t,e.center,e.radius)){var n=function t(e){if(e<0){e+=2*Math.PI}if(e>2*Math.PI){e-=2*Math.PI}return e};var l=Math.atan2(e.center.y-t.y,t.x-e.center.x);l=-1*l;if(l<0){l+=2*Math.PI}var i=e.angleList.map(function(t){t=n(-1*t);return t});i.forEach(function(t,e){var a=n(t-r/2);var i=n(t+r/2);if(i<a){i+=2*Math.PI}if(l>=a&&l<=i||l+2*Math.PI>=a&&l+2*Math.PI<=i){o=e}})}return o}function findFunnelChartCurrentIndex(t,e){var a=-1;for(var i=0,r=e.series.length;i<r;i++){var o=e.series[i];if(t.x>o.funnelArea[0]&&t.x<o.funnelArea[2]&&t.y>o.funnelArea[1]&&t.y<o.funnelArea[3]){a=i;break}}return a}function findWordChartCurrentIndex(t,e){var a=-1;for(var i=0,r=e.length;i<r;i++){var o=e[i];if(t.x>o.area[0]&&t.x<o.area[2]&&t.y>o.area[1]&&t.y<o.area[3]){a=i;break}}return a}function findMapChartCurrentIndex(t,e){var a=-1;var i=e.chartData.mapData;var r=e.series;var o=pointToCoordinate(t.y,t.x,i.bounds,i.scale,i.xoffset,i.yoffset);var n=[o.x,o.y];for(var l=0,s=r.length;l<s;l++){var h=r[l].geometry.coordinates;if(isPoiWithinPoly(n,h,e.chartData.mapData.mercator)){a=l;break}}return a}function findRoseChartCurrentIndex(t,e,a){var i=-1;var r=getRoseDataPoints(a._series_,a.extra.rose.type,e.radius,e.radius);if(e&&e.center&&isInExactPieChartArea(t,e.center,e.radius)){var o=Math.atan2(e.center.y-t.y,t.x-e.center.x);o=-o;if(a.extra.rose&&a.extra.rose.offsetAngle){o=o-a.extra.rose.offsetAngle*Math.PI/180}for(var n=0,l=r.length;n<l;n++){if(isInAngleRange(o,r[n]._start_,r[n]._start_+r[n]._rose_proportion_*2*Math.PI)){i=n;break}}}return i}function findPieChartCurrentIndex(t,e,a){var i=-1;var r=getPieDataPoints(e.series);if(e&&e.center&&isInExactPieChartArea(t,e.center,e.radius)){var o=Math.atan2(e.center.y-t.y,t.x-e.center.x);o=-o;if(a.extra.pie&&a.extra.pie.offsetAngle){o=o-a.extra.pie.offsetAngle*Math.PI/180}if(a.extra.ring&&a.extra.ring.offsetAngle){o=o-a.extra.ring.offsetAngle*Math.PI/180}for(var n=0,l=r.length;n<l;n++){if(isInAngleRange(o,r[n]._start_,r[n]._start_+r[n]._proportion_*2*Math.PI)){i=n;break}}}return i}function isInExactPieChartArea(t,e,a){return Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2)<=Math.pow(a,2)}function splitPoints(t,a){var i=[];var r=[];t.forEach(function(t,e){if(a.connectNulls){if(t!==null){r.push(t)}}else{if(t!==null){r.push(t)}else{if(r.length){i.push(r)}r=[]}}});if(r.length){i.push(r)}return i}function calLegendData(l,s,e,t,h){let c={area:{start:{x:0,y:0},end:{x:0,y:0},width:0,height:0,wholeWidth:0,wholeHeight:0},points:[],widthArr:[],heightArr:[]};if(s.legend.show===false){t.legendData=c;return c}let d=s.legend.padding*s.pix;let x=s.legend.margin*s.pix;let f=s.legend.fontSize?s.legend.fontSize*s.pix:e.fontSize;let p=15*s.pix;let u=5*s.pix;let g=Math.max(s.legend.lineHeight*s.pix,f);if(s.legend.position=="top"||s.legend.position=="bottom"){let i=[];let r=0;let o=[];let n=[];for(let a=0;a<l.length;a++){let t=l[a];const y=t.legendText?t.legendText:t.name;let e=p+u+measureText(y||"undefined",f,h)+s.legend.itemGap*s.pix;if(r+e>s.width-s.area[1]-s.area[3]){i.push(n);o.push(r-s.legend.itemGap*s.pix);r=e;n=[t]}else{r+=e;n.push(t)}}if(n.length){i.push(n);o.push(r-s.legend.itemGap*s.pix);c.widthArr=o;let t=Math.max.apply(null,o);switch(s.legend.float){case"left":c.area.start.x=s.area[3];c.area.end.x=s.area[3]+t+2*d;break;case"right":c.area.start.x=s.width-s.area[1]-t-2*d;c.area.end.x=s.width-s.area[1];break;default:c.area.start.x=(s.width-t)/2-d;c.area.end.x=(s.width+t)/2+d}c.area.width=t+2*d;c.area.wholeWidth=t+2*d;c.area.height=i.length*g+2*d;c.area.wholeHeight=i.length*g+2*d+2*x;c.points=i}}else{let t=l.length;let e=s.height-s.area[0]-s.area[2]-2*x-2*d;let a=Math.min(Math.floor(e/g),t);c.area.height=a*g+d*2;c.area.wholeHeight=a*g+d*2;switch(s.legend.float){case"top":c.area.start.y=s.area[0]+x;c.area.end.y=s.area[0]+x+c.area.height;break;case"bottom":c.area.start.y=s.height-s.area[2]-x-c.area.height;c.area.end.y=s.height-s.area[2]-x;break;default:c.area.start.y=(s.height-c.area.height)/2;c.area.end.y=(s.height+c.area.height)/2}let i=t%a===0?t/a:Math.floor(t/a+1);let r=[];for(let e=0;e<i;e++){let t=l.slice(e*a,e*a+a);r.push(t)}c.points=r;if(r.length){for(let t=0;t<r.length;t++){let a=r[t];let i=0;for(let e=0;e<a.length;e++){let t=p+u+measureText(a[e].name||"undefined",f,h)+s.legend.itemGap*s.pix;if(t>i){i=t}}c.widthArr.push(i);c.heightArr.push(a.length*g+d*2)}let e=0;for(let t=0;t<c.widthArr.length;t++){e+=c.widthArr[t]}c.area.width=e-s.legend.itemGap*s.pix+2*d;c.area.wholeWidth=c.area.width+d}}switch(s.legend.position){case"top":c.area.start.y=s.area[0]+x;c.area.end.y=s.area[0]+x+c.area.height;break;case"bottom":c.area.start.y=s.height-s.area[2]-c.area.height-x;c.area.end.y=s.height-s.area[2]-x;break;case"left":c.area.start.x=s.area[3];c.area.end.x=s.area[3]+c.area.width;break;case"right":c.area.start.x=s.width-s.area[1]-c.area.width;c.area.end.x=s.width-s.area[1];break}t.legendData=c;return c}function calCategoriesData(t,i,e,a,r){var o={angle:0,xAxisHeight:e.xAxisHeight};var n=i.xAxis.fontSize*i.pix||e.fontSize;var l=t.map(function(t,e){var a=i.xAxis.formatter?i.xAxis.formatter(t,e,i):t;return measureText(String(a),n,r)});var s=Math.max.apply(this,l);if(i.xAxis.rotateLabel==true){o.angle=i.xAxis.rotateAngle*Math.PI/180;let t=2*e.xAxisTextPadding+Math.abs(s*Math.sin(o.angle));t=t<n+2*e.xAxisTextPadding?t+2*e.xAxisTextPadding:t;if(i.enableScroll==true&&i.xAxis.scrollShow==true){t+=12*i.pix}o.xAxisHeight=t}if(i.xAxis.disabled){o.xAxisHeight=0}return o}function getXAxisTextList(t,e,h,c){var a=arguments.length>4&&arguments[4]!==undefined?arguments[4]:-1;var i;if(c=="stack"){i=dataCombineStack(t,e.categories.length)}else{i=dataCombine(t)}var r=[];i=i.filter(function(t){if(typeof t==="object"&&t!==null){if(t.constructor.toString().indexOf("Array")>-1){return t!==null}else{return t.value!==null}}else{return t!==null}});i.map(function(t){if(typeof t==="object"){if(t.constructor.toString().indexOf("Array")>-1){if(e.type=="candle"){t.map(function(t){r.push(t)})}else{r.push(t[0])}}else{r.push(t.value)}}else{r.push(t)}});var o=0;var n=0;if(r.length>0){o=Math.min.apply(this,r);n=Math.max.apply(this,r)}if(a>-1){if(typeof e.xAxis.data[a].min==="number"){o=Math.min(e.xAxis.data[a].min,o)}if(typeof e.xAxis.data[a].max==="number"){n=Math.max(e.xAxis.data[a].max,n)}}else{if(typeof e.xAxis.min==="number"){o=Math.min(e.xAxis.min,o)}if(typeof e.xAxis.max==="number"){n=Math.max(e.xAxis.max,n)}}if(o===n){var d=n||10;n+=d}var l=o;var x=n;var f=[];var p=(x-l)/e.xAxis.splitNumber;for(var s=0;s<=e.xAxis.splitNumber;s++){f.push(l+p*s)}return f}function calXAxisData(t,e,a,i){var r=assign({},{type:""},e.extra.bar);var o={angle:0,xAxisHeight:a.xAxisHeight};o.ranges=getXAxisTextList(t,e,a,r.type);o.rangesFormat=o.ranges.map(function(t){t=util.toFixed(t,2);return t});var n=o.ranges.map(function(t){t=util.toFixed(t,2);return t});o=Object.assign(o,getXAxisPoints(n,e,a));var l=o.eachSpacing;var s=n.map(function(t){return measureText(t,e.xAxis.fontSize*e.pix||a.fontSize,i)});var h=Math.max.apply(this,s);if(h+2*a.xAxisTextPadding>l){o.angle=45*Math.PI/180;o.xAxisHeight=2*a.xAxisTextPadding+h*Math.sin(o.angle)}if(e.xAxis.disabled===true){o.xAxisHeight=0}return o}function getRadarDataPoints(r,o,n,a,t){var l=arguments.length>5&&arguments[5]!==undefined?arguments[5]:1;var e=t.extra.radar||{};e.max=e.max||0;var s=Math.max(e.max,Math.max.apply(null,dataCombine(a)));var h=[];for(let e=0;e<a.length;e++){let t=a[e];let i={};i.color=t.color;i.legendShape=t.legendShape;i.pointShape=t.pointShape;i.data=[];t.data.forEach(function(t,e){let a={};a.angle=r[e];a.proportion=t/s;a.value=t;a.position=convertCoordinateOrigin(n*a.proportion*l*Math.cos(a.angle),n*a.proportion*l*Math.sin(a.angle),o);i.data.push(a)});h.push(i)}return h}function getPieDataPoints(a,i){var r=arguments.length>2&&arguments[2]!==undefined?arguments[2]:1;var o=0;var n=0;for(let e=0;e<a.length;e++){let t=a[e];t.data=t.data===null?0:t.data;o+=t.data}for(let e=0;e<a.length;e++){let t=a[e];t.data=t.data===null?0:t.data;if(o===0){t._proportion_=1/a.length*r}else{t._proportion_=t.data/o*r}t._radius_=i}for(let e=0;e<a.length;e++){let t=a[e];t._start_=n;n+=2*t._proportion_*Math.PI}return a}function getFunnelDataPoints(e,a,i,r){var o=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;e=e.sort(function(t,e){return parseInt(e.data)-parseInt(t.data)});for(let t=0;t<e.length;t++){if(i=="funnel"){e[t].radius=e[t].data/e[0].data*a*o}else{e[t].radius=r*(e.length-t)/(r*e.length)*a*o}e[t]._proportion_=e[t].data/e[0].data}if(i!=="pyramid"){e.reverse()}return e}function getRoseDataPoints(a,i,r,o){var n=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;var l=0;var s=0;var h=[];for(let e=0;e<a.length;e++){let t=a[e];t.data=t.data===null?0:t.data;l+=t.data;h.push(t.data)}var c=Math.min.apply(null,h);var d=Math.max.apply(null,h);var x=o-r;for(let e=0;e<a.length;e++){let t=a[e];t.data=t.data===null?0:t.data;if(l===0){t._proportion_=1/a.length*n;t._rose_proportion_=1/a.length*n}else{t._proportion_=t.data/l*n;if(i=="area"){t._rose_proportion_=1/a.length*n}else{t._rose_proportion_=t.data/l*n}}t._radius_=r+x*((t.data-c)/(d-c))||o}for(let e=0;e<a.length;e++){let t=a[e];t._start_=s;s+=2*t._rose_proportion_*Math.PI}return a}function getArcbarDataPoints(i,r){var o=arguments.length>2&&arguments[2]!==undefined?arguments[2]:1;if(o==1){o=.999999}for(let a=0;a<i.length;a++){let t=i[a];t.data=t.data===null?0:t.data;let e;if(r.type=="circle"){e=2}else{if(r.endAngle<r.startAngle){e=2+r.endAngle-r.startAngle}else{e=r.startAngle-r.endAngle}}t._proportion_=e*t.data*o+r.startAngle;if(t._proportion_>=2){t._proportion_=t._proportion_%2}}return i}function getGaugeArcbarDataPoints(i,r){var o=arguments.length>2&&arguments[2]!==undefined?arguments[2]:1;if(o==1){o=.999999}for(let a=0;a<i.length;a++){let t=i[a];t.data=t.data===null?0:t.data;let e;if(r.type=="circle"){e=2}else{if(r.endAngle<r.startAngle){e=2+r.endAngle-r.startAngle}else{e=r.startAngle-r.endAngle}}t._proportion_=e*t.data*o+r.startAngle;if(t._proportion_>=2){t._proportion_=t._proportion_%2}}return i}function getGaugeAxisPoints(e,a,t){let i=a-t+1;let r=a;for(let t=0;t<e.length;t++){e[t].value=e[t].value===null?0:e[t].value;e[t]._startAngle_=r;e[t]._endAngle_=i*e[t].value+a;if(e[t]._endAngle_>=2){e[t]._endAngle_=e[t]._endAngle_%2}r=e[t]._endAngle_}return e}function getGaugeDataPoints(i,r,o){let n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:1;for(let a=0;a<i.length;a++){let e=i[a];e.data=e.data===null?0:e.data;if(o.pointer.color=="auto"){for(let t=0;t<r.length;t++){if(e.data<=r[t].value){e.color=r[t].color;break}}}else{e.color=o.pointer.color}let t=o.startAngle-o.endAngle+1;e._endAngle_=t*e.data+o.startAngle;e._oldAngle_=o.oldAngle;if(o.oldAngle<o.endAngle){e._oldAngle_+=2}if(e.data>=o.oldData){e._proportion_=(e._endAngle_-e._oldAngle_)*n+o.oldAngle}else{e._proportion_=e._oldAngle_-(e._oldAngle_-e._endAngle_)*n}if(e._proportion_>=2){e._proportion_=e._proportion_%2}}return i}function getPieTextMaxLength(i,r,o,n){i=getPieDataPoints(i);let l=0;for(let a=0;a<i.length;a++){let t=i[a];let e=t.formatter?t.formatter(+t._proportion_.toFixed(2)):util.toFixed(t._proportion_*100)+"%";l=Math.max(l,measureText(e,t.textSize*n.pix||r.fontSize,o))}return l}function fixColumeData(t,i,r,o,e,n){return t.map(function(t){if(t===null){return null}var e=0;var a=0;if(n.type=="mix"){e=n.extra.mix.column.seriesGap*n.pix||0;a=n.extra.mix.column.categoryGap*n.pix||0}else{e=n.extra.column.seriesGap*n.pix||0;a=n.extra.column.categoryGap*n.pix||0}e=Math.min(e,i/r);a=Math.min(a,i/r);t.width=Math.ceil((i-2*a-e*(r-1))/r);if(n.extra.mix&&n.extra.mix.column.width&&+n.extra.mix.column.width>0){t.width=Math.min(t.width,+n.extra.mix.column.width*n.pix)}if(n.extra.column&&n.extra.column.width&&+n.extra.column.width>0){t.width=Math.min(t.width,+n.extra.column.width*n.pix)}if(t.width<=0){t.width=1}t.x+=(o+.5-r/2)*(t.width+e);return t})}function fixBarData(t,i,r,o,e,n){return t.map(function(t){if(t===null){return null}var e=0;var a=0;e=n.extra.bar.seriesGap*n.pix||0;a=n.extra.bar.categoryGap*n.pix||0;e=Math.min(e,i/r);a=Math.min(a,i/r);t.width=Math.ceil((i-2*a-e*(r-1))/r);if(n.extra.bar&&n.extra.bar.width&&+n.extra.bar.width>0){t.width=Math.min(t.width,+n.extra.bar.width*n.pix)}if(t.width<=0){t.width=1}t.y+=(o+.5-r/2)*(t.width+e);return t})}function fixColumeMeterData(t,e,a,i,r,o,n){var l=o.extra.column.categoryGap*o.pix||0;return t.map(function(t){if(t===null){return null}t.width=e-2*l;if(o.extra.column&&o.extra.column.width&&+o.extra.column.width>0){t.width=Math.min(t.width,+o.extra.column.width*o.pix)}if(i>0){t.width-=n}return t})}function fixColumeStackData(t,a,e,i,r,o,n){var l=o.extra.column.categoryGap*o.pix||0;return t.map(function(t,e){if(t===null){return null}t.width=Math.ceil(a-2*l);if(o.extra.column&&o.extra.column.width&&+o.extra.column.width>0){t.width=Math.min(t.width,+o.extra.column.width*o.pix)}if(t.width<=0){t.width=1}return t})}function fixBarStackData(t,a,e,i,r,o,n){var l=o.extra.bar.categoryGap*o.pix||0;return t.map(function(t,e){if(t===null){return null}t.width=Math.ceil(a-2*l);if(o.extra.bar&&o.extra.bar.width&&+o.extra.bar.width>0){t.width=Math.min(t.width,+o.extra.bar.width*o.pix)}if(t.width<=0){t.width=1}return t})}function getXAxisPoints(t,e,h){var a=e.width-e.area[1]-e.area[3];var i=e.enableScroll?Math.min(e.xAxis.itemCount,t.length):t.length;if((e.type=="line"||e.type=="area"||e.type=="scatter"||e.type=="bubble"||e.type=="bar")&&i>1&&e.xAxis.boundaryGap=="justify"){i-=1}var r=0;if(e.type=="mount"&&e.extra&&e.extra.mount&&e.extra.mount.widthRatio&&e.extra.mount.widthRatio>1){if(e.extra.mount.widthRatio>2)e.extra.mount.widthRatio=2;r=e.extra.mount.widthRatio-1;i+=r}var o=a/i;var n=[];var l=e.area[3];var s=e.width-e.area[1];t.forEach(function(t,e){n.push(l+r/2*o+e*o)});if(e.xAxis.boundaryGap!=="justify"){if(e.enableScroll===true){n.push(l+r*o+t.length*o)}else{n.push(s)}}return{xAxisPoints:n,startX:l,endX:s,eachSpacing:o}}function getCandleDataPoints(t,l,s,h,c,d,a){var x=arguments.length>7&&arguments[7]!==undefined?arguments[7]:1;var e=[];var f=d.height-d.area[0]-d.area[2];t.forEach(function(t,o){if(t===null){e.push(null)}else{var n=[];t.forEach(function(t,e){var a={};a.x=h[o]+Math.round(c/2);var i=t.value||t;var r=f*(i-l)/(s-l);r*=x;a.y=d.height-Math.round(r)-d.area[2];n.push(a)});e.push(n)}});return e}function getDataPoints(t,a,n,l,s,h,e){var c=arguments.length>7&&arguments[7]!==undefined?arguments[7]:1;var d="center";if(h.type=="line"||h.type=="area"||h.type=="scatter"||h.type=="bubble"){d=h.xAxis.boundaryGap}var x=[];var f=h.height-h.area[0]-h.area[2];var p=h.width-h.area[1]-h.area[3];t.forEach(function(i,t){if(i===null){x.push(null)}else{var r={};r.color=i.color;r.x=l[t];var o=i;if(typeof i==="object"&&i!==null){if(i.constructor.toString().indexOf("Array")>-1){let t,e,a;t=[].concat(h.chartData.xAxisData.ranges);e=t.shift();a=t.pop();o=i[1];r.x=h.area[3]+p*(i[0]-e)/(a-e);if(h.type=="bubble"){r.r=i[2];r.t=i[3]}}else{o=i.value}}if(d=="center"){r.x+=s/2}var e=f*(o-a)/(n-a);e*=c;r.y=h.height-e-h.area[2];x.push(r)}});return x}function getMountDataPoints(t,o,n,l,s,h,e){var c=arguments.length>7&&arguments[7]!==undefined?arguments[7]:1;var d=[];var x=h.height-h.area[0]-h.area[2];var a=h.width-h.area[1]-h.area[3];var f=s*e.widthRatio;t.forEach(function(t,e){if(t===null){d.push(null)}else{var a={};a.color=t.color;a.x=l[e];a.x+=s/2;var i=t.data;var r=x*(i-o)/(n-o);r*=c;a.y=h.height-r-h.area[2];a.value=i;a.width=f;d.push(a)}});return d}function getBarDataPoints(t,o,n,l,e,s,a){var h=arguments.length>7&&arguments[7]!==undefined?arguments[7]:1;var c=[];var i=s.height-s.area[0]-s.area[2];var d=s.width-s.area[1]-s.area[3];t.forEach(function(t,e){if(t===null){c.push(null)}else{var a={};a.color=t.color;a.y=l[e];var i=t;if(typeof t==="object"&&t!==null){i=t.value}var r=d*(i-o)/(n-o);r*=h;a.height=r;a.value=i;a.x=r+s.area[3];c.push(a)}});return c}function getStackDataPoints(t,s,h,c,u,d,e,x,y){var f=arguments.length>9&&arguments[9]!==undefined?arguments[9]:1;var p=[];var g=d.height-d.area[0]-d.area[2];t.forEach(function(t,e){if(t===null){p.push(null)}else{var a={};a.color=t.color;a.x=c[e]+Math.round(u/2);if(x>0){var i=0;for(let t=0;t<=x;t++){i+=y[t].data[e]}var r=i-t;var o=g*(i-s)/(h-s);var n=g*(r-s)/(h-s)}else{var i=t;var o=g*(i-s)/(h-s);var n=0}var l=n;o*=f;l*=f;a.y=d.height-Math.round(o)-d.area[2];a.y0=d.height-Math.round(l)-d.area[2];p.push(a)}});return p}function getBarStackDataPoints(t,s,h,c,e,d,a,x,u){var f=arguments.length>9&&arguments[9]!==undefined?arguments[9]:1;var p=[];var g=d.width-d.area[1]-d.area[3];t.forEach(function(t,e){if(t===null){p.push(null)}else{var a={};a.color=t.color;a.y=c[e];if(x>0){var i=0;for(let t=0;t<=x;t++){i+=u[t].data[e]}var r=i-t;var o=g*(i-s)/(h-s);var n=g*(r-s)/(h-s)}else{var i=t;var o=g*(i-s)/(h-s);var n=0}var l=n;o*=f;l*=f;a.height=o-l;a.x=d.area[3]+o;a.x0=d.area[3]+l;p.push(a)}});return p}function getYAxisTextList(t,e,h,c,a){var d=arguments.length>5&&arguments[5]!==undefined?arguments[5]:-1;var i;if(c=="stack"){i=dataCombineStack(t,e.categories.length)}else{i=dataCombine(t)}var r=[];i=i.filter(function(t){if(typeof t==="object"&&t!==null){if(t.constructor.toString().indexOf("Array")>-1){return t!==null}else{return t.value!==null}}else{return t!==null}});i.map(function(t){if(typeof t==="object"){if(t.constructor.toString().indexOf("Array")>-1){if(e.type=="candle"){t.map(function(t){r.push(t)})}else{r.push(t[1])}}else{r.push(t.value)}}else{r.push(t)}});var o=a.min||0;var n=a.max||0;if(r.length>0){o=Math.min.apply(this,r);n=Math.max.apply(this,r)}if(o===n){if(n==0){n=10}else{o=0}}var l=getDataRange(o,n);var x=a.min===undefined||a.min===null?l.minRange:a.min;var f=a.max===undefined||a.max===null?l.maxRange:a.max;var p=[];var g=(f-x)/e.yAxis.splitNumber;for(var s=0;s<=e.yAxis.splitNumber;s++){p.push(x+g*s)}return p.reverse()}function calYAxisData(a,o,e,n){var l=assign({},{type:""},o.extra.column);var t=o.yAxis.data.length;var s=new Array(t);if(t>0){for(let e=0;e<t;e++){s[e]=[];for(let t=0;t<a.length;t++){if(a[t].index==e){s[e].push(a[t])}}}var h=new Array(t);var c=new Array(t);var d=new Array(t);for(let r=0;r<t;r++){let i=o.yAxis.data[r];if(o.yAxis.disabled==true){i.disabled=true}if(i.type==="categories"){if(!i.formatter){i.formatter=(t,e,a)=>{return t+(i.unit||"")}}i.categories=i.categories||o.categories;h[r]=i.categories}else{if(!i.formatter){i.formatter=(t,e,a)=>{return t.toFixed(i.tofix)+(i.unit||"")}}h[r]=getYAxisTextList(s[r],o,e,l.type,i,r)}let a=i.fontSize*o.pix||e.fontSize;d[r]={position:i.position?i.position:"left",width:0};c[r]=h[r].map(function(t,e){t=i.formatter(t,e,o);d[r].width=Math.max(d[r].width,measureText(t,a,n)+5);return t});let t=i.calibration?4*o.pix:0;d[r].width+=t+3*o.pix;if(i.disabled===true){d[r].width=0}}}else{var h=new Array(1);var c=new Array(1);var d=new Array(1);if(o.type==="bar"){h[0]=o.categories;if(!o.yAxis.formatter){o.yAxis.formatter=(t,e,a)=>{return t+(a.yAxis.unit||"")}}}else{if(!o.yAxis.formatter){o.yAxis.formatter=(t,e,a)=>{return t.toFixed(a.yAxis.tofix)+(a.yAxis.unit||"")}}h[0]=getYAxisTextList(a,o,e,l.type,{})}d[0]={position:"left",width:0};var i=o.yAxis.fontSize*o.pix||e.fontSize;c[0]=h[0].map(function(t,e){t=o.yAxis.formatter(t,e,o);d[0].width=Math.max(d[0].width,measureText(t,i,n)+5);return t});d[0].width+=3*o.pix;if(o.yAxis.disabled===true){d[0]={position:"left",width:0};o.yAxis.data[0]={disabled:true}}else{o.yAxis.data[0]={disabled:false,position:"left",max:o.yAxis.max,min:o.yAxis.min,formatter:o.yAxis.formatter};if(o.type==="bar"){o.yAxis.data[0].categories=o.categories;o.yAxis.data[0].type="categories"}}}return{rangesFormat:c,ranges:h,yAxisWidth:d}}function calTooltipYAxisData(r,t,o,e,a){let n=[].concat(o.chartData.yAxisData.ranges);let l=o.height-o.area[0]-o.area[2];let s=o.area[0];let h=[];for(let i=0;i<n.length;i++){let t=n[i].shift();let e=n[i].pop();let a=t-(t-e)*(r-s)/l;a=o.yAxis.data[i].formatter?o.yAxis.data[i].formatter(a):a.toFixed(0);h.push(String(a))}return h}function calMarkLineData(i,r){let o,n;let l=r.height-r.area[0]-r.area[2];for(let a=0;a<i.length;a++){i[a].yAxisIndex=i[a].yAxisIndex?i[a].yAxisIndex:0;let t=[].concat(r.chartData.yAxisData.ranges[i[a].yAxisIndex]);o=t.pop();n=t.shift();let e=l*(i[a].value-o)/(n-o);i[a].y=r.height-Math.round(e)-r.area[2]}return i}function contextRotate(t,e){if(e.rotateLock!==true){t.translate(e.height,0);t.rotate(90*Math.PI/180)}else if(e._rotate_!==true){t.translate(e.height,0);t.rotate(90*Math.PI/180);e._rotate_=true}}function drawPointShape(t,e,a,i,r){i.beginPath();if(r.dataPointShapeType=="hollow"){i.setStrokeStyle(e);i.setFillStyle(r.background);i.setLineWidth(2*r.pix)}else{i.setStrokeStyle("#ffffff");i.setFillStyle(e);i.setLineWidth(1*r.pix)}if(a==="diamond"){t.forEach(function(t,e){if(t!==null){i.moveTo(t.x,t.y-4.5);i.lineTo(t.x-4.5,t.y);i.lineTo(t.x,t.y+4.5);i.lineTo(t.x+4.5,t.y);i.lineTo(t.x,t.y-4.5)}})}else if(a==="circle"){t.forEach(function(t,e){if(t!==null){i.moveTo(t.x+2.5*r.pix,t.y);i.arc(t.x,t.y,3*r.pix,0,2*Math.PI,false)}})}else if(a==="square"){t.forEach(function(t,e){if(t!==null){i.moveTo(t.x-3.5,t.y-3.5);i.rect(t.x-3.5,t.y-3.5,7,7)}})}else if(a==="triangle"){t.forEach(function(t,e){if(t!==null){i.moveTo(t.x,t.y-4.5);i.lineTo(t.x-4.5,t.y+4.5);i.lineTo(t.x+4.5,t.y+4.5);i.lineTo(t.x,t.y-4.5)}})}else if(a==="triangle"){return}i.closePath();i.fill();i.stroke()}function drawRingTitle(t,e,a,i){var r=t.title.fontSize||e.titleFontSize;var o=t.subtitle.fontSize||e.subtitleFontSize;var n=t.title.name||"";var l=t.subtitle.name||"";var c=t.title.color||t.fontColor;var d=t.subtitle.color||t.fontColor;var x=n?r:0;var f=l?o:0;var s=5;if(l){var p=measureText(l,o*t.pix,a);var g=i.x-p/2+(t.subtitle.offsetX||0)*t.pix;var h=i.y+o*t.pix/2+(t.subtitle.offsetY||0)*t.pix;if(n){h+=(x*t.pix+s)/2}a.beginPath();a.setFontSize(o*t.pix);a.setFillStyle(d);a.fillText(l,g,h);a.closePath();a.stroke()}if(n){var u=measureText(n,r*t.pix,a);var y=i.x-u/2+(t.title.offsetX||0);var v=i.y+r*t.pix/2+(t.title.offsetY||0)*t.pix;if(l){v-=(f*t.pix+s)/2}a.beginPath();a.setFontSize(r*t.pix);a.setFillStyle(c);a.fillText(n,y,v);a.closePath();a.stroke()}}function drawPointText(t,o,n,l,s){var h=o.data;var c=o.textOffset?o.textOffset:0;t.forEach(function(t,e){if(t!==null){l.beginPath();var a=o.textSize?o.textSize*s.pix:n.fontSize;l.setFontSize(a);l.setFillStyle(o.textColor||s.fontColor);var i=h[e];if(typeof h[e]==="object"&&h[e]!==null){if(h[e].constructor.toString().indexOf("Array")>-1){i=h[e][1]}else{i=h[e].value}}var r=o.formatter?o.formatter(i,e,o,s):i;l.setTextAlign("center");l.fillText(String(r),t.x,t.y-4+c*s.pix);l.closePath();l.stroke();l.setTextAlign("left")}})}function drawMountPointText(t,o,n,l,s){var e=o.data;var h=o.textOffset?o.textOffset:0;t.forEach(function(t,e){if(t!==null){l.beginPath();var a=o[e].textSize?o[e].textSize*s.pix:n.fontSize;l.setFontSize(a);l.setFillStyle(o[e].textColor||s.fontColor);var i=t.value;var r=o[e].formatter?o[e].formatter(i,e,o,s):i;l.setTextAlign("center");l.fillText(String(r),t.x,t.y-4+h*s.pix);l.closePath();l.stroke();l.setTextAlign("left")}})}function drawBarPointText(t,o,n,l,s){var h=o.data;var e=o.textOffset?o.textOffset:0;t.forEach(function(t,e){if(t!==null){l.beginPath();var a=o.textSize?o.textSize*s.pix:n.fontSize;l.setFontSize(a);l.setFillStyle(o.textColor||s.fontColor);var i=h[e];if(typeof h[e]==="object"&&h[e]!==null){i=h[e].value}var r=o.formatter?o.formatter(i,e,o,s):i;l.setTextAlign("left");l.fillText(String(r),t.x+4*s.pix,t.y+a/2-3);l.closePath();l.stroke()}})}function drawGaugeLabel(e,a,i,r,o,n){a-=e.width/2+e.labelOffset*r.pix;a=a<10?10:a;let t=e.startAngle-e.endAngle+1;let d=t/e.splitLine.splitNumber;let x=e.endNumber-e.startNumber;let f=x/e.splitLine.splitNumber;let l=e.startAngle;let s=e.startNumber;for(let t=0;t<e.splitLine.splitNumber+1;t++){var h={x:a*Math.cos(l*Math.PI),y:a*Math.sin(l*Math.PI)};var c=e.formatter?e.formatter(s,t,r):s;h.x+=i.x-measureText(c,o.fontSize,n)/2;h.y+=i.y;var p=h.x;var g=h.y;n.beginPath();n.setFontSize(o.fontSize);n.setFillStyle(e.labelColor||r.fontColor);n.fillText(c,p,g+o.fontSize/2);n.closePath();n.stroke();l+=d;if(l>=2){l=l%2}s+=f}}function drawRadarLabel(t,s,h,c,d,x){var f=c.extra.radar||{};t.forEach(function(t,e){if(f.labelPointShow===true&&c.categories[e]!==""){var a={x:s*Math.cos(t),y:s*Math.sin(t)};var i=convertCoordinateOrigin(a.x,a.y,h);x.setFillStyle(f.labelPointColor);x.beginPath();x.arc(i.x,i.y,f.labelPointRadius*c.pix,0,2*Math.PI,false);x.closePath();x.fill()}var r={x:(s+d.radarLabelTextMargin*c.pix)*Math.cos(t),y:(s+d.radarLabelTextMargin*c.pix)*Math.sin(t)};var o=convertCoordinateOrigin(r.x,r.y,h);var n=o.x;var l=o.y;if(util.approximatelyEqual(r.x,0)){n-=measureText(c.categories[e]||"",d.fontSize,x)/2}else if(r.x<0){n-=measureText(c.categories[e]||"",d.fontSize,x)}x.beginPath();x.setFontSize(d.fontSize);x.setFillStyle(f.labelColor||c.fontColor);x.fillText(c.categories[e]||"",n,l+d.fontSize/2);x.closePath();x.stroke()})}function drawPieText(n,d,x,f,t,l){var p=x.pieChartLinePadding;var g=[];var u=null;var y=n.map(function(t,e){var a=t.formatter?t.formatter(t,e,n,d):util.toFixed(t._proportion_.toFixed(4)*100)+"%";a=t.labelText?t.labelText:a;var i=2*Math.PI-(t._start_+2*Math.PI*t._proportion_/2);if(t._rose_proportion_){i=2*Math.PI-(t._start_+2*Math.PI*t._rose_proportion_/2)}var r=t.color;var o=t._radius_;return{arc:i,text:a,color:r,radius:o,textColor:t.textColor,textSize:t.textSize,labelShow:t.labelShow}});for(let c=0;c<y.length;c++){let t=y[c];let e=Math.cos(t.arc)*(t.radius+p);let a=Math.sin(t.arc)*(t.radius+p);let i=Math.cos(t.arc)*t.radius;let r=Math.sin(t.arc)*t.radius;let o=e>=0?e+x.pieChartTextPadding:e-x.pieChartTextPadding;let n=a;let l=measureText(t.text,t.textSize*d.pix||x.fontSize,f);let s=n;if(u&&util.isSameXCoordinateArea(u.start,{x:o})){if(o>0){s=Math.min(n,u.start.y)}else if(e<0){s=Math.max(n,u.start.y)}else{if(n>0){s=Math.max(n,u.start.y)}else{s=Math.min(n,u.start.y)}}}if(o<0){o-=l}let h={lineStart:{x:i,y:r},lineEnd:{x:e,y:a},start:{x:o,y:s},width:l,height:x.fontSize,text:t.text,color:t.color,textColor:t.textColor,textSize:t.textSize};u=avoidCollision(h,u);g.push(u)}for(let n=0;n<g.length;n++){if(y[n].labelShow===false){continue}let t=g[n];let e=convertCoordinateOrigin(t.lineStart.x,t.lineStart.y,l);let a=convertCoordinateOrigin(t.lineEnd.x,t.lineEnd.y,l);let i=convertCoordinateOrigin(t.start.x,t.start.y,l);f.setLineWidth(1*d.pix);f.setFontSize(t.textSize*d.pix||x.fontSize);f.beginPath();f.setStrokeStyle(t.color);f.setFillStyle(t.color);f.moveTo(e.x,e.y);let r=t.start.x<0?i.x+t.width:i.x;let o=t.start.x<0?i.x-5:i.x+5;f.quadraticCurveTo(a.x,a.y,r,i.y);f.moveTo(e.x,e.y);f.stroke();f.closePath();f.beginPath();f.moveTo(i.x+t.width,i.y);f.arc(r,i.y,2*d.pix,0,2*Math.PI);f.closePath();f.fill();f.beginPath();f.setFontSize(t.textSize*d.pix||x.fontSize);f.setFillStyle(t.textColor||d.fontColor);f.fillText(t.text,o,i.y+3);f.closePath();f.stroke();f.closePath()}}function drawToolTipSplitLine(r,o,n,l){var s=o.extra.tooltip||{};s.gridType=s.gridType==undefined?"solid":s.gridType;s.dashLength=s.dashLength==undefined?4:s.dashLength;var t=o.area[0];var h=o.height-o.area[2];if(s.gridType=="dash"){l.setLineDash([s.dashLength,s.dashLength])}l.setStrokeStyle(s.gridColor||"#cccccc");l.setLineWidth(1*o.pix);l.beginPath();l.moveTo(r,t);l.lineTo(r,h);l.stroke();l.setLineDash([]);if(s.xAxisLabel){let t=o.categories[o.tooltip.index];l.setFontSize(n.fontSize);let e=measureText(t,n.fontSize,l);let a=r-.5*e;let i=h;l.beginPath();l.setFillStyle(hexToRgb(s.labelBgColor||n.toolTipBackground,s.labelBgOpacity||n.toolTipOpacity));l.setStrokeStyle(s.labelBgColor||n.toolTipBackground);l.setLineWidth(1*o.pix);l.rect(a-n.toolTipPadding,i,e+2*n.toolTipPadding,n.fontSize+2*n.toolTipPadding);l.closePath();l.stroke();l.fill();l.beginPath();l.setFontSize(n.fontSize);l.setFillStyle(s.labelFontColor||o.fontColor);l.fillText(String(t),a,i+n.toolTipPadding+n.fontSize);l.closePath();l.stroke()}}function drawMarkLine(s,h,c){let e=assign({},{type:"solid",dashLength:4,data:[]},s.extra.markLine);let a=s.area[3];let i=s.width-s.area[1];let r=calMarkLineData(e.data,s);for(let t=0;t<r.length;t++){let l=assign({},{lineColor:"#DE4A42",showLabel:false,labelFontColor:"#666666",labelBgColor:"#DFE8FF",labelBgOpacity:.8,labelAlign:"left",labelOffsetX:0,labelOffsetY:0},r[t]);if(e.type=="dash"){c.setLineDash([e.dashLength,e.dashLength])}c.setStrokeStyle(l.lineColor);c.setLineWidth(1*s.pix);c.beginPath();c.moveTo(a,l.y);c.lineTo(i,l.y);c.stroke();c.setLineDash([]);if(l.showLabel){let t=l.labelText?l.labelText:l.value;c.setFontSize(h.fontSize);let e=measureText(t,h.fontSize,c);let a=e+h.toolTipPadding*2;let i=l.labelAlign=="left"?s.area[3]-a:s.width-s.area[1];i+=l.labelOffsetX;let r=l.y-.5*h.fontSize-h.toolTipPadding;r+=l.labelOffsetY;let o=i+h.toolTipPadding;let n=l.y;c.setFillStyle(hexToRgb(l.labelBgColor,l.labelBgOpacity));c.setStrokeStyle(l.labelBgColor);c.setLineWidth(1*s.pix);c.beginPath();c.rect(i,r,a,h.fontSize+2*h.toolTipPadding);c.closePath();c.stroke();c.fill();c.setFontSize(h.fontSize);c.setTextAlign("left");c.setFillStyle(l.labelFontColor);c.fillText(String(t),o,r+h.fontSize+h.toolTipPadding/2);c.stroke();c.setTextAlign("left")}}}function drawToolTipHorizentalLine(d,x,f,t,e){var p=assign({},{gridType:"solid",dashLength:4},d.extra.tooltip);var a=d.area[3];var i=d.width-d.area[1];if(p.gridType=="dash"){f.setLineDash([p.dashLength,p.dashLength])}f.setStrokeStyle(p.gridColor||"#cccccc");f.setLineWidth(1*d.pix);f.beginPath();f.moveTo(a,d.tooltip.offset.y);f.lineTo(i,d.tooltip.offset.y);f.stroke();f.setLineDash([]);if(p.yAxisLabel){let l=calTooltipYAxisData(d.tooltip.offset.y,d.series,d,x,t);let s=d.chartData.yAxisData.yAxisWidth;let h=d.area[3];let c=d.width-d.area[1];for(let n=0;n<l.length;n++){f.setFontSize(x.fontSize);let t=measureText(l[n],x.fontSize,f);let e,a,i;if(s[n].position=="left"){e=h-s[n].width;a=Math.max(e,e+t+x.toolTipPadding*2)}else{e=c;a=Math.max(e+s[n].width,e+t+x.toolTipPadding*2)}i=a-e;let r=e+(i-t)/2;let o=d.tooltip.offset.y;f.beginPath();f.setFillStyle(hexToRgb(p.labelBgColor||x.toolTipBackground,p.labelBgOpacity||x.toolTipOpacity));f.setStrokeStyle(p.labelBgColor||x.toolTipBackground);f.setLineWidth(1*d.pix);f.rect(e,o-.5*x.fontSize-x.toolTipPadding,i,x.fontSize+2*x.toolTipPadding);f.closePath();f.stroke();f.fill();f.beginPath();f.setFontSize(x.fontSize);f.setFillStyle(p.labelFontColor||d.fontColor);f.fillText(l[n],r,o+.5*x.fontSize);f.closePath();f.stroke();if(s[n].position=="left"){h-=s[n].width+d.yAxis.padding*d.pix}else{c+=s[n].width+d.yAxis.padding*d.pix}}}}function drawToolTipSplitArea(t,e,a,i,r){var o=assign({},{activeBgColor:"#000000",activeBgOpacity:.08,activeWidth:r},e.extra.column);o.activeWidth=o.activeWidth>r?r:o.activeWidth;var n=e.area[0];var l=e.height-e.area[2];i.beginPath();i.setFillStyle(hexToRgb(o.activeBgColor,o.activeBgOpacity));i.rect(t-o.activeWidth/2,n,o.activeWidth,l-n);i.closePath();i.fill();i.setFillStyle("#FFFFFF")}function drawBarToolTipSplitArea(t,e,a,i,r){var o=assign({},{activeBgColor:"#000000",activeBgOpacity:.08},e.extra.bar);var n=e.area[3];var l=e.width-e.area[1];i.beginPath();i.setFillStyle(hexToRgb(o.activeBgColor,o.activeBgOpacity));i.rect(n,t-r/2,l-n,r);i.closePath();i.fill();i.setFillStyle("#FFFFFF")}function drawToolTip(t,r,e,o,n,c,d){var l=assign({},{showBox:true,showArrow:true,showCategory:false,bgColor:"#000000",bgOpacity:.7,borderColor:"#000000",borderWidth:0,borderRadius:0,borderOpacity:.7,fontColor:"#FFFFFF",splitLine:true},e.extra.tooltip);if(l.showCategory==true&&e.categories){t.unshift({text:e.categories[e.tooltip.index],color:null})}var x=4*e.pix;var f=5*e.pix;var s=l.showArrow?8*e.pix:0;var p=false;if(e.type=="line"||e.type=="mount"||e.type=="area"||e.type=="candle"||e.type=="mix"){if(l.splitLine==true){drawToolTipSplitLine(e.tooltip.offset.x,e,o,n)}}r=assign({x:0,y:0},r);r.y-=8*e.pix;var g=t.map(function(t){return measureText(t.text,o.fontSize,n)});var h=x+f+4*o.toolTipPadding+Math.max.apply(null,g);var a=2*o.toolTipPadding+t.length*o.toolTipLineHeight;if(l.showBox==false){return}if(r.x-Math.abs(e._scrollDistance_||0)+s+h>e.width){p=true}if(a+r.y>e.height){r.y=e.height-a}n.beginPath();n.setFillStyle(hexToRgb(l.bgColor||o.toolTipBackground,l.bgOpacity||o.toolTipOpacity));n.setLineWidth(l.borderWidth*e.pix);n.setStrokeStyle(hexToRgb(l.borderColor,l.borderOpacity));var i=l.borderRadius;if(p){if(l.showArrow){n.moveTo(r.x,r.y+10*e.pix);n.lineTo(r.x-s,r.y+10*e.pix+5*e.pix)}n.arc(r.x-s-i,r.y+a-i,i,0,Math.PI/2,false);n.arc(r.x-s-Math.round(h)+i,r.y+a-i,i,Math.PI/2,Math.PI,false);n.arc(r.x-s-Math.round(h)+i,r.y+i,i,-Math.PI,-Math.PI/2,false);n.arc(r.x-s-i,r.y+i,i,-Math.PI/2,0,false);if(l.showArrow){n.lineTo(r.x-s,r.y+10*e.pix-5*e.pix);n.lineTo(r.x,r.y+10*e.pix)}}else{if(l.showArrow){n.moveTo(r.x,r.y+10*e.pix);n.lineTo(r.x+s,r.y+10*e.pix-5*e.pix)}n.arc(r.x+s+i,r.y+i,i,-Math.PI,-Math.PI/2,false);n.arc(r.x+s+Math.round(h)-i,r.y+i,i,-Math.PI/2,0,false);n.arc(r.x+s+Math.round(h)-i,r.y+a-i,i,0,Math.PI/2,false);n.arc(r.x+s+i,r.y+a-i,i,Math.PI/2,Math.PI,false);if(l.showArrow){n.lineTo(r.x+s,r.y+10*e.pix+5*e.pix);n.lineTo(r.x,r.y+10*e.pix)}}n.closePath();n.fill();if(l.borderWidth>0){n.stroke()}t.forEach(function(t,e){if(t.color!==null){n.beginPath();n.setFillStyle(t.color);var a=r.x+s+2*o.toolTipPadding;var i=r.y+(o.toolTipLineHeight-o.fontSize)/2+o.toolTipLineHeight*e+o.toolTipPadding+1;if(p){a=r.x-h-s+2*o.toolTipPadding}n.fillRect(a,i,x,o.fontSize);n.closePath()}});t.forEach(function(t,e){var a=r.x+s+2*o.toolTipPadding+x+f;if(p){a=r.x-h-s+2*o.toolTipPadding+ +x+f}var i=r.y+(o.toolTipLineHeight-o.fontSize)/2+o.toolTipLineHeight*e+o.toolTipPadding;n.beginPath();n.setFontSize(o.fontSize);n.setFillStyle(l.fontColor);n.fillText(t.text,a,i+o.fontSize);n.closePath();n.stroke()})}function drawColumnDataPoints(y,v,m,T){let b=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;let t=v.chartData.xAxisData,P=t.xAxisPoints,w=t.eachSpacing;let S=assign({},{type:"group",width:w/2,meterBorder:4,meterFillColor:"#FFFFFF",barBorderCircle:false,barBorderRadius:[],seriesGap:2,linearType:"none",linearOpacity:1,customColor:[],colorStop:0},v.extra.column);let A=[];T.save();let C=-2;let D=P.length+2;if(v._scrollDistance_&&v._scrollDistance_!==0&&v.enableScroll===true){T.translate(v._scrollDistance_,0);C=Math.floor(-v._scrollDistance_/w)-2;D=C+v.xAxis.itemCount+4}if(v.tooltip&&v.tooltip.textList&&v.tooltip.textList.length&&b===1){drawToolTipSplitArea(v.tooltip.offset.x,v,m,T,w)}S.customColor=fillCustomColor(S.linearType,S.customColor,y,m);y.forEach(function(a,i){let t,o,x;t=[].concat(v.chartData.yAxisData.ranges[a.index]);o=t.pop();x=t.shift();var f=a.data;switch(S.type){case"group":var r=getDataPoints(f,o,x,P,w,v,m,b);var p=getStackDataPoints(f,o,x,P,w,v,m,i,y,b);A.push(p);r=fixColumeData(r,w,y.length,i,m,v);for(let t=0;t<r.length;t++){let o=r[t];if(o!==null&&t>C&&t<D){var n=o.x-o.width/2;var l=v.height-o.y-v.area[2];T.beginPath();var s=o.color||a.color;var g=o.color||a.color;if(S.linearType!=="none"){var e=T.createLinearGradient(n,o.y,n,v.height-v.area[2]);if(S.linearType=="opacity"){e.addColorStop(0,hexToRgb(s,S.linearOpacity));e.addColorStop(1,hexToRgb(s,1))}else{e.addColorStop(0,hexToRgb(S.customColor[a.linearIndex],S.linearOpacity));e.addColorStop(S.colorStop,hexToRgb(S.customColor[a.linearIndex],S.linearOpacity));e.addColorStop(1,hexToRgb(s,1))}s=e}if(S.barBorderRadius&&S.barBorderRadius.length===4||S.barBorderCircle===true){const h=n;const c=o.y;const d=o.width;const l=v.height-v.area[2]-o.y;if(S.barBorderCircle){S.barBorderRadius=[d/2,d/2,0,0]}let[t,e,a,i]=S.barBorderRadius;let r=Math.min(d/2,l/2);t=t>r?r:t;e=e>r?r:e;a=a>r?r:a;i=i>r?r:i;t=t<0?0:t;e=e<0?0:e;a=a<0?0:a;i=i<0?0:i;T.arc(h+t,c+t,t,-Math.PI,-Math.PI/2);T.arc(h+d-e,c+e,e,-Math.PI/2,0);T.arc(h+d-a,c+l-a,a,0,Math.PI/2);T.arc(h+i,c+l-i,i,Math.PI/2,Math.PI)}else{T.moveTo(n,o.y);T.lineTo(n+o.width,o.y);T.lineTo(n+o.width,v.height-v.area[2]);T.lineTo(n,v.height-v.area[2]);T.lineTo(n,o.y);T.setLineWidth(1);T.setStrokeStyle(g)}T.setFillStyle(s);T.closePath();T.fill()}};break;case"stack":var r=getStackDataPoints(f,o,x,P,w,v,m,i,y,b);A.push(r);r=fixColumeStackData(r,w,y.length,i,m,v,y);for(let e=0;e<r.length;e++){let t=r[e];if(t!==null&&e>C&&e<D){T.beginPath();var s=t.color||a.color;var n=t.x-t.width/2+1;var l=v.height-t.y-v.area[2];var u=v.height-t.y0-v.area[2];if(i>0){l-=u}T.setFillStyle(s);T.moveTo(n,t.y);T.fillRect(n,t.y,t.width,l);T.closePath();T.fill()}};break;case"meter":var r=getDataPoints(f,o,x,P,w,v,m,b);A.push(r);r=fixColumeMeterData(r,w,y.length,i,m,v,S.meterBorder);for(let t=0;t<r.length;t++){let o=r[t];if(o!==null&&t>C&&t<D){T.beginPath();if(i==0&&S.meterBorder>0){T.setStrokeStyle(a.color);T.setLineWidth(S.meterBorder*v.pix)}if(i==0){T.setFillStyle(S.meterFillColor)}else{T.setFillStyle(o.color||a.color)}var n=o.x-o.width/2;var l=v.height-o.y-v.area[2];if(S.barBorderRadius&&S.barBorderRadius.length===4||S.barBorderCircle===true){const h=n;const c=o.y;const d=o.width;const l=v.height-v.area[2]-o.y;if(S.barBorderCircle){S.barBorderRadius=[d/2,d/2,0,0]}let[t,e,a,i]=S.barBorderRadius;let r=Math.min(d/2,l/2);t=t>r?r:t;e=e>r?r:e;a=a>r?r:a;i=i>r?r:i;t=t<0?0:t;e=e<0?0:e;a=a<0?0:a;i=i<0?0:i;T.arc(h+t,c+t,t,-Math.PI,-Math.PI/2);T.arc(h+d-e,c+e,e,-Math.PI/2,0);T.arc(h+d-a,c+l-a,a,0,Math.PI/2);T.arc(h+i,c+l-i,i,Math.PI/2,Math.PI);T.fill()}else{T.moveTo(n,o.y);T.lineTo(n+o.width,o.y);T.lineTo(n+o.width,v.height-v.area[2]);T.lineTo(n,v.height-v.area[2]);T.lineTo(n,o.y);T.fill()}if(i==0&&S.meterBorder>0){T.closePath();T.stroke()}}}break}});if(v.dataLabel!==false&&b===1){y.forEach(function(t,e){let a,i,r;a=[].concat(v.chartData.yAxisData.ranges[t.index]);i=a.pop();r=a.shift();var o=t.data;switch(S.type){case"group":var n=getDataPoints(o,i,r,P,w,v,m,b);n=fixColumeData(n,w,y.length,e,m,v);drawPointText(n,t,m,T,v);break;case"stack":var n=getStackDataPoints(o,i,r,P,w,v,m,e,y,b);drawPointText(n,t,m,T,v);break;case"meter":var n=getDataPoints(o,i,r,P,w,v,m,b);drawPointText(n,t,m,T,v);break}})}T.restore();return{xAxisPoints:P,calPoints:A,eachSpacing:w}}function drawMountDataPoints(i,n,o,l){let f=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;let t=n.chartData.xAxisData,p=t.xAxisPoints,r=t.eachSpacing;let s=assign({},{type:"mount",widthRatio:1,borderWidth:1,barBorderCircle:false,barBorderRadius:[],linearType:"none",linearOpacity:1,customColor:[],colorStop:0},n.extra.mount);s.widthRatio=s.widthRatio<=0?0:s.widthRatio;s.widthRatio=s.widthRatio>=2?2:s.widthRatio;let e=[];l.save();let a=-2;let g=p.length+2;if(n._scrollDistance_&&n._scrollDistance_!==0&&n.enableScroll===true){l.translate(n._scrollDistance_,0);a=Math.floor(-n._scrollDistance_/r)-2;g=a+n.xAxis.itemCount+4}s.customColor=fillCustomColor(s.linearType,s.customColor,i,o);let u,y,v;u=[].concat(n.chartData.yAxisData.ranges[0]);y=u.pop();v=u.shift();var h=getMountDataPoints(i,y,v,p,r,n,s,f);switch(s.type){case"bar":for(let t=0;t<h.length;t++){let o=h[t];if(o!==null&&t>a&&t<g){var c=o.x-r*s.widthRatio/2;var m=n.height-o.y-n.area[2];l.beginPath();var d=o.color||i[t].color;var T=o.color||i[t].color;if(s.linearType!=="none"){var x=l.createLinearGradient(c,o.y,c,n.height-n.area[2]);if(s.linearType=="opacity"){x.addColorStop(0,hexToRgb(d,s.linearOpacity));x.addColorStop(1,hexToRgb(d,1))}else{x.addColorStop(0,hexToRgb(s.customColor[i[t].linearIndex],s.linearOpacity));x.addColorStop(s.colorStop,hexToRgb(s.customColor[i[t].linearIndex],s.linearOpacity));x.addColorStop(1,hexToRgb(d,1))}d=x}if(s.barBorderRadius&&s.barBorderRadius.length===4||s.barBorderCircle===true){const b=c;const P=o.y;const w=o.width;const m=n.height-n.area[2]-o.y-s.borderWidth*n.pix/2;if(s.barBorderCircle){s.barBorderRadius=[w/2,w/2,0,0]}let[t,e,a,i]=s.barBorderRadius;let r=Math.min(w/2,m/2);t=t>r?r:t;e=e>r?r:e;a=a>r?r:a;i=i>r?r:i;t=t<0?0:t;e=e<0?0:e;a=a<0?0:a;i=i<0?0:i;l.arc(b+t,P+t,t,-Math.PI,-Math.PI/2);l.arc(b+w-e,P+e,e,-Math.PI/2,0);l.arc(b+w-a,P+m-a,a,0,Math.PI/2);l.arc(b+i,P+m-i,i,Math.PI/2,Math.PI)}else{l.moveTo(c,o.y);l.lineTo(c+o.width,o.y);l.lineTo(c+o.width,n.height-n.area[2]);l.lineTo(c,n.height-n.area[2]);l.lineTo(c,o.y)}l.setStrokeStyle(T);l.setFillStyle(d);if(s.borderWidth>0){l.setLineWidth(s.borderWidth*n.pix);l.closePath();l.stroke()}l.fill()}};break;case"triangle":for(let e=0;e<h.length;e++){let t=h[e];if(t!==null&&e>a&&e<g){var c=t.x-r*s.widthRatio/2;var m=n.height-t.y-n.area[2];l.beginPath();var d=t.color||i[e].color;var T=t.color||i[e].color;if(s.linearType!=="none"){var x=l.createLinearGradient(c,t.y,c,n.height-n.area[2]);if(s.linearType=="opacity"){x.addColorStop(0,hexToRgb(d,s.linearOpacity));x.addColorStop(1,hexToRgb(d,1))}else{x.addColorStop(0,hexToRgb(s.customColor[i[e].linearIndex],s.linearOpacity));x.addColorStop(s.colorStop,hexToRgb(s.customColor[i[e].linearIndex],s.linearOpacity));x.addColorStop(1,hexToRgb(d,1))}d=x}l.moveTo(c,n.height-n.area[2]);l.lineTo(t.x,t.y);l.lineTo(c+t.width,n.height-n.area[2]);l.setStrokeStyle(T);l.setFillStyle(d);if(s.borderWidth>0){l.setLineWidth(s.borderWidth*n.pix);l.stroke()}l.fill()}};break;case"mount":for(let e=0;e<h.length;e++){let t=h[e];if(t!==null&&e>a&&e<g){var c=t.x-r*s.widthRatio/2;var m=n.height-t.y-n.area[2];l.beginPath();var d=t.color||i[e].color;var T=t.color||i[e].color;if(s.linearType!=="none"){var x=l.createLinearGradient(c,t.y,c,n.height-n.area[2]);if(s.linearType=="opacity"){x.addColorStop(0,hexToRgb(d,s.linearOpacity));x.addColorStop(1,hexToRgb(d,1))}else{x.addColorStop(0,hexToRgb(s.customColor[i[e].linearIndex],s.linearOpacity));x.addColorStop(s.colorStop,hexToRgb(s.customColor[i[e].linearIndex],s.linearOpacity));x.addColorStop(1,hexToRgb(d,1))}d=x}l.moveTo(c,n.height-n.area[2]);l.bezierCurveTo(t.x-t.width/4,n.height-n.area[2],t.x-t.width/4,t.y,t.x,t.y);l.bezierCurveTo(t.x+t.width/4,t.y,t.x+t.width/4,n.height-n.area[2],c+t.width,n.height-n.area[2]);l.setStrokeStyle(T);l.setFillStyle(d);if(s.borderWidth>0){l.setLineWidth(s.borderWidth*n.pix);l.stroke()}l.fill()}};break;case"sharp":for(let e=0;e<h.length;e++){let t=h[e];if(t!==null&&e>a&&e<g){var c=t.x-r*s.widthRatio/2;var m=n.height-t.y-n.area[2];l.beginPath();var d=t.color||i[e].color;var T=t.color||i[e].color;if(s.linearType!=="none"){var x=l.createLinearGradient(c,t.y,c,n.height-n.area[2]);if(s.linearType=="opacity"){x.addColorStop(0,hexToRgb(d,s.linearOpacity));x.addColorStop(1,hexToRgb(d,1))}else{x.addColorStop(0,hexToRgb(s.customColor[i[e].linearIndex],s.linearOpacity));x.addColorStop(s.colorStop,hexToRgb(s.customColor[i[e].linearIndex],s.linearOpacity));x.addColorStop(1,hexToRgb(d,1))}d=x}l.moveTo(c,n.height-n.area[2]);l.quadraticCurveTo(t.x-0,n.height-n.area[2]-m/4,t.x,t.y);l.quadraticCurveTo(t.x+0,n.height-n.area[2]-m/4,c+t.width,n.height-n.area[2]);l.setStrokeStyle(T);l.setFillStyle(d);if(s.borderWidth>0){l.setLineWidth(s.borderWidth*n.pix);l.stroke()}l.fill()}};break}if(n.dataLabel!==false&&f===1){let t,e,a;t=[].concat(n.chartData.yAxisData.ranges[0]);e=t.pop();a=t.shift();var h=getMountDataPoints(i,e,a,p,r,n,s,f);drawMountPointText(h,i,o,l,n)}l.restore();return{xAxisPoints:p,calPoints:h,eachSpacing:r}}function drawBarDataPoints(y,v,m,T){let b=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;let P=[];let w=(v.height-v.area[0]-v.area[2])/v.categories.length;for(let t=0;t<v.categories.length;t++){P.push(v.area[0]+w/2+w*t)}let S=assign({},{type:"group",width:w/2,meterBorder:4,meterFillColor:"#FFFFFF",barBorderCircle:false,barBorderRadius:[],seriesGap:2,linearType:"none",linearOpacity:1,customColor:[],colorStop:0},v.extra.bar);let A=[];T.save();let C=-2;let D=P.length+2;if(v.tooltip&&v.tooltip.textList&&v.tooltip.textList.length&&b===1){drawBarToolTipSplitArea(v.tooltip.offset.y,v,m,T,w)}S.customColor=fillCustomColor(S.linearType,S.customColor,y,m);y.forEach(function(a,t){let o,e,d;o=[].concat(v.chartData.xAxisData.ranges);d=o.pop();e=o.shift();var x=a.data;switch(S.type){case"group":var i=getBarDataPoints(x,e,d,P,w,v,m,b);var f=getBarStackDataPoints(x,e,d,P,w,v,m,t,y,b);A.push(f);i=fixBarData(i,w,y.length,t,m,v);for(let t=0;t<i.length;t++){let o=i[t];if(o!==null&&t>C&&t<D){var n=v.area[3];var r=o.y-o.width/2;var p=o.height;T.beginPath();var l=o.color||a.color;var g=o.color||a.color;if(S.linearType!=="none"){var s=T.createLinearGradient(n,o.y,o.x,o.y);if(S.linearType=="opacity"){s.addColorStop(0,hexToRgb(l,S.linearOpacity));s.addColorStop(1,hexToRgb(l,1))}else{s.addColorStop(0,hexToRgb(S.customColor[a.linearIndex],S.linearOpacity));s.addColorStop(S.colorStop,hexToRgb(S.customColor[a.linearIndex],S.linearOpacity));s.addColorStop(1,hexToRgb(l,1))}l=s}if(S.barBorderRadius&&S.barBorderRadius.length===4||S.barBorderCircle===true){const u=n;const h=o.width;const c=o.y-o.width/2;const p=o.height;if(S.barBorderCircle){S.barBorderRadius=[h/2,h/2,0,0]}let[t,e,a,i]=S.barBorderRadius;let r=Math.min(h/2,p/2);t=t>r?r:t;e=e>r?r:e;a=a>r?r:a;i=i>r?r:i;t=t<0?0:t;e=e<0?0:e;a=a<0?0:a;i=i<0?0:i;T.arc(u+i,c+i,i,-Math.PI,-Math.PI/2);T.arc(o.x-t,c+t,t,-Math.PI/2,0);T.arc(o.x-e,c+h-e,e,0,Math.PI/2);T.arc(u+a,c+h-a,a,Math.PI/2,Math.PI)}else{T.moveTo(n,r);T.lineTo(o.x,r);T.lineTo(o.x,r+o.width);T.lineTo(n,r+o.width);T.lineTo(n,r);T.setLineWidth(1);T.setStrokeStyle(g)}T.setFillStyle(l);T.closePath();T.fill()}};break;case"stack":var i=getBarStackDataPoints(x,e,d,P,w,v,m,t,y,b);A.push(i);i=fixBarStackData(i,w,y.length,t,m,v,y);for(let e=0;e<i.length;e++){let t=i[e];if(t!==null&&e>C&&e<D){T.beginPath();var l=t.color||a.color;var n=t.x0;T.setFillStyle(l);T.moveTo(n,t.y-t.width/2);T.fillRect(n,t.y-t.width/2,t.height,t.width);T.closePath();T.fill()}};break}});if(v.dataLabel!==false&&b===1){y.forEach(function(t,e){let a,i,r;a=[].concat(v.chartData.xAxisData.ranges);r=a.pop();i=a.shift();var o=t.data;switch(S.type){case"group":var n=getBarDataPoints(o,i,r,P,w,v,m,b);n=fixBarData(n,w,y.length,e,m,v);drawBarPointText(n,t,m,T,v);break;case"stack":var n=getBarStackDataPoints(o,i,r,P,w,v,m,e,y,b);drawBarPointText(n,t,m,T,v);break}})}return{yAxisPoints:P,calPoints:A,eachSpacing:w}}function drawCandleDataPoints(e,t,h,c,d){var u=arguments.length>5&&arguments[5]!==undefined?arguments[5]:1;var s=assign({},{color:{},average:{}},h.extra.candle);s.color=assign({},{upLine:"#f04864",upFill:"#f04864",downLine:"#2fc25b",downFill:"#2fc25b"},s.color);s.average=assign({},{show:false,name:[],day:[],color:c.color},s.average);h.extra.candle=s;let a=h.chartData.xAxisData,x=a.xAxisPoints,f=a.eachSpacing;let y=[];d.save();let p=-2;let v=x.length+2;let g=0;let m=h.width+f;if(h._scrollDistance_&&h._scrollDistance_!==0&&h.enableScroll===true){d.translate(h._scrollDistance_,0);p=Math.floor(-h._scrollDistance_/f)-2;v=p+h.xAxis.itemCount+4;g=-h._scrollDistance_-f*2+h.area[3];m=g+(h.xAxis.itemCount+4)*f}if(s.average.show||t){t.forEach(function(e,t){let a,i,r;a=[].concat(h.chartData.yAxisData.ranges[e.index]);i=a.pop();r=a.shift();var o=e.data;var n=getDataPoints(o,i,r,x,f,h,c,u);var l=splitPoints(n,e);for(let t=0;t<l.length;t++){let i=l[t];d.beginPath();d.setStrokeStyle(e.color);d.setLineWidth(1);if(i.length===1){d.moveTo(i[0].x,i[0].y);d.arc(i[0].x,i[0].y,1,0,2*Math.PI)}else{d.moveTo(i[0].x,i[0].y);let a=0;for(let e=0;e<i.length;e++){let t=i[e];if(a==0&&t.x>g){d.moveTo(t.x,t.y);a=1}if(e>0&&t.x>g&&t.x<m){var s=createCurveControlPoints(i,e-1);d.bezierCurveTo(s.ctrA.x,s.ctrA.y,s.ctrB.x,s.ctrB.y,t.x,t.y)}}d.moveTo(i[0].x,i[0].y)}d.closePath();d.stroke()}})}e.forEach(function(t,e){let a,i,r;a=[].concat(h.chartData.yAxisData.ranges[t.index]);i=a.pop();r=a.shift();var o=t.data;var n=getCandleDataPoints(o,i,r,x,f,h,c,u);y.push(n);var l=splitPoints(n,t);for(let e=0;e<l[0].length;e++){if(e>p&&e<v){let t=l[0][e];d.beginPath();if(o[e][1]-o[e][0]>0){d.setStrokeStyle(s.color.upLine);d.setFillStyle(s.color.upFill);d.setLineWidth(1*h.pix);d.moveTo(t[3].x,t[3].y);d.lineTo(t[1].x,t[1].y);d.lineTo(t[1].x-f/4,t[1].y);d.lineTo(t[0].x-f/4,t[0].y);d.lineTo(t[0].x,t[0].y);d.lineTo(t[2].x,t[2].y);d.lineTo(t[0].x,t[0].y);d.lineTo(t[0].x+f/4,t[0].y);d.lineTo(t[1].x+f/4,t[1].y);d.lineTo(t[1].x,t[1].y);d.moveTo(t[3].x,t[3].y)}else{d.setStrokeStyle(s.color.downLine);d.setFillStyle(s.color.downFill);d.setLineWidth(1*h.pix);d.moveTo(t[3].x,t[3].y);d.lineTo(t[0].x,t[0].y);d.lineTo(t[0].x-f/4,t[0].y);d.lineTo(t[1].x-f/4,t[1].y);d.lineTo(t[1].x,t[1].y);d.lineTo(t[2].x,t[2].y);d.lineTo(t[1].x,t[1].y);d.lineTo(t[1].x+f/4,t[1].y);d.lineTo(t[0].x+f/4,t[0].y);d.lineTo(t[0].x,t[0].y);d.moveTo(t[3].x,t[3].y)}d.closePath();d.fill();d.stroke()}}});d.restore();return{xAxisPoints:x,calPoints:y,eachSpacing:f}}function drawAreaDataPoints(t,s,h,c){var d=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;var x=assign({},{type:"straight",opacity:.2,addLine:false,width:2,gradient:false},s.extra.area);let e=s.chartData.xAxisData,y=e.xAxisPoints,f=e.eachSpacing;let p=s.height-s.area[2];let v=[];c.save();let g=0;let u=s.width+f;if(s._scrollDistance_&&s._scrollDistance_!==0&&s.enableScroll===true){c.translate(s._scrollDistance_,0);g=-s._scrollDistance_-f*2+s.area[3];u=g+(s.xAxis.itemCount+4)*f}t.forEach(function(e,t){let a,i,r;a=[].concat(s.chartData.yAxisData.ranges[e.index]);i=a.pop();r=a.shift();let o=e.data;let n=getDataPoints(o,i,r,y,f,s,h,d);v.push(n);let l=splitPoints(n,e);for(let t=0;t<l.length;t++){let r=l[t];c.beginPath();c.setStrokeStyle(hexToRgb(e.color,x.opacity));if(x.gradient){let t=c.createLinearGradient(0,s.area[0],0,s.height-s.area[2]);t.addColorStop("0",hexToRgb(e.color,x.opacity));t.addColorStop("1.0",hexToRgb("#FFFFFF",.1));c.setFillStyle(t)}else{c.setFillStyle(hexToRgb(e.color,x.opacity))}c.setLineWidth(x.width*s.pix);if(r.length>1){let t=r[0];let e=r[r.length-1];c.moveTo(t.x,t.y);let i=0;if(x.type==="curve"){for(let a=0;a<r.length;a++){let e=r[a];if(i==0&&e.x>g){c.moveTo(e.x,e.y);i=1}if(a>0&&e.x>g&&e.x<u){let t=createCurveControlPoints(r,a-1);c.bezierCurveTo(t.ctrA.x,t.ctrA.y,t.ctrB.x,t.ctrB.y,e.x,e.y)}}}if(x.type==="straight"){for(let e=0;e<r.length;e++){let t=r[e];if(i==0&&t.x>g){c.moveTo(t.x,t.y);i=1}if(e>0&&t.x>g&&t.x<u){c.lineTo(t.x,t.y)}}}if(x.type==="step"){for(let e=0;e<r.length;e++){let t=r[e];if(i==0&&t.x>g){c.moveTo(t.x,t.y);i=1}if(e>0&&t.x>g&&t.x<u){c.lineTo(t.x,r[e-1].y);c.lineTo(t.x,t.y)}}}c.lineTo(e.x,p);c.lineTo(t.x,p);c.lineTo(t.x,t.y)}else{let t=r[0];c.moveTo(t.x-f/2,t.y);c.lineTo(t.x+f/2,t.y);c.lineTo(t.x+f/2,p);c.lineTo(t.x-f/2,p);c.moveTo(t.x-f/2,t.y)}c.closePath();c.fill();if(x.addLine){if(e.lineType=="dash"){let t=e.dashLength?e.dashLength:8;t*=s.pix;c.setLineDash([t,t])}c.beginPath();c.setStrokeStyle(e.color);c.setLineWidth(x.width*s.pix);if(r.length===1){c.moveTo(r[0].x,r[0].y);c.arc(r[0].x,r[0].y,1,0,2*Math.PI)}else{c.moveTo(r[0].x,r[0].y);let i=0;if(x.type==="curve"){for(let a=0;a<r.length;a++){let e=r[a];if(i==0&&e.x>g){c.moveTo(e.x,e.y);i=1}if(a>0&&e.x>g&&e.x<u){let t=createCurveControlPoints(r,a-1);c.bezierCurveTo(t.ctrA.x,t.ctrA.y,t.ctrB.x,t.ctrB.y,e.x,e.y)}}}if(x.type==="straight"){for(let e=0;e<r.length;e++){let t=r[e];if(i==0&&t.x>g){c.moveTo(t.x,t.y);i=1}if(e>0&&t.x>g&&t.x<u){c.lineTo(t.x,t.y)}}}if(x.type==="step"){for(let e=0;e<r.length;e++){let t=r[e];if(i==0&&t.x>g){c.moveTo(t.x,t.y);i=1}if(e>0&&t.x>g&&t.x<u){c.lineTo(t.x,r[e-1].y);c.lineTo(t.x,t.y)}}}c.moveTo(r[0].x,r[0].y)}c.stroke();c.setLineDash([])}}if(s.dataPointShape!==false){drawPointShape(n,e.color,e.pointShape,c,s)}});if(s.dataLabel!==false&&d===1){t.forEach(function(t,e){let a,i,r;a=[].concat(s.chartData.yAxisData.ranges[t.index]);i=a.pop();r=a.shift();var o=t.data;var n=getDataPoints(o,i,r,y,f,s,h,d);drawPointText(n,t,h,c,s)})}c.restore();return{xAxisPoints:y,calPoints:v,eachSpacing:f}}function drawScatterDataPoints(t,s,h,c){var d=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;var i=assign({},{type:"circle"},s.extra.scatter);let e=s.chartData.xAxisData,x=e.xAxisPoints,f=e.eachSpacing;var r=[];c.save();let a=0;let o=s.width+f;if(s._scrollDistance_&&s._scrollDistance_!==0&&s.enableScroll===true){c.translate(s._scrollDistance_,0);a=-s._scrollDistance_-f*2+s.area[3];o=a+(s.xAxis.itemCount+4)*f}t.forEach(function(t,e){let a,i,r;a=[].concat(s.chartData.yAxisData.ranges[t.index]);i=a.pop();r=a.shift();var o=t.data;var n=getDataPoints(o,i,r,x,f,s,h,d);c.beginPath();c.setStrokeStyle(t.color);c.setFillStyle(t.color);c.setLineWidth(1*s.pix);var l=t.pointShape;if(l==="diamond"){n.forEach(function(t,e){if(t!==null){c.moveTo(t.x,t.y-4.5);c.lineTo(t.x-4.5,t.y);c.lineTo(t.x,t.y+4.5);c.lineTo(t.x+4.5,t.y);c.lineTo(t.x,t.y-4.5)}})}else if(l==="circle"){n.forEach(function(t,e){if(t!==null){c.moveTo(t.x+2.5*s.pix,t.y);c.arc(t.x,t.y,3*s.pix,0,2*Math.PI,false)}})}else if(l==="square"){n.forEach(function(t,e){if(t!==null){c.moveTo(t.x-3.5,t.y-3.5);c.rect(t.x-3.5,t.y-3.5,7,7)}})}else if(l==="triangle"){n.forEach(function(t,e){if(t!==null){c.moveTo(t.x,t.y-4.5);c.lineTo(t.x-4.5,t.y+4.5);c.lineTo(t.x+4.5,t.y+4.5);c.lineTo(t.x,t.y-4.5)}})}else if(l==="triangle"){return}c.closePath();c.fill();c.stroke()});if(s.dataLabel!==false&&d===1){t.forEach(function(t,e){let a,i,r;a=[].concat(s.chartData.yAxisData.ranges[t.index]);i=a.pop();r=a.shift();var o=t.data;var n=getDataPoints(o,i,r,x,f,s,h,d);drawPointText(n,t,h,c,s)})}c.restore();return{xAxisPoints:x,calPoints:r,eachSpacing:f}}function drawBubbleDataPoints(l,s,h,c){var d=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;var x=assign({},{opacity:1,border:2},s.extra.bubble);let t=s.chartData.xAxisData,f=t.xAxisPoints,p=t.eachSpacing;var e=[];c.save();let a=0;let i=s.width+p;if(s._scrollDistance_&&s._scrollDistance_!==0&&s.enableScroll===true){c.translate(s._scrollDistance_,0);a=-s._scrollDistance_-p*2+s.area[3];i=a+(s.xAxis.itemCount+4)*p}l.forEach(function(t,e){let a,i,r;a=[].concat(s.chartData.yAxisData.ranges[t.index]);i=a.pop();r=a.shift();var o=t.data;var n=getDataPoints(o,i,r,f,p,s,h,d);c.beginPath();c.setStrokeStyle(t.color);c.setLineWidth(x.border*s.pix);c.setFillStyle(hexToRgb(t.color,x.opacity));n.forEach(function(t,e){c.moveTo(t.x+t.r,t.y);c.arc(t.x,t.y,t.r*s.pix,0,2*Math.PI,false)});c.closePath();c.fill();c.stroke();if(s.dataLabel!==false&&d===1){n.forEach(function(t,e){c.beginPath();var a=l.textSize*s.pix||h.fontSize;c.setFontSize(a);c.setFillStyle(l.textColor||"#FFFFFF");c.setTextAlign("center");c.fillText(String(t.t),t.x,t.y+a/2);c.closePath();c.stroke();c.setTextAlign("left")})}});c.restore();return{xAxisPoints:f,calPoints:e,eachSpacing:p}}function drawLineDataPoints(t,s,h,c){var d=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;var x=assign({},{type:"straight",width:2},s.extra.line);x.width*=s.pix;let e=s.chartData.xAxisData,f=e.xAxisPoints,p=e.eachSpacing;var y=[];c.save();let g=0;let u=s.width+p;if(s._scrollDistance_&&s._scrollDistance_!==0&&s.enableScroll===true){c.translate(s._scrollDistance_,0);g=-s._scrollDistance_-p*2+s.area[3];u=g+(s.xAxis.itemCount+4)*p}t.forEach(function(e,t){let a,i,r;a=[].concat(s.chartData.yAxisData.ranges[e.index]);i=a.pop();r=a.shift();var o=e.data;var n=getDataPoints(o,i,r,f,p,s,h,d);y.push(n);var l=splitPoints(n,e);if(e.lineType=="dash"){let t=e.dashLength?e.dashLength:8;t*=s.pix;c.setLineDash([t,t])}c.beginPath();c.setStrokeStyle(e.color);c.setLineWidth(x.width);l.forEach(function(i,t){if(i.length===1){c.moveTo(i[0].x,i[0].y);c.arc(i[0].x,i[0].y,1,0,2*Math.PI)}else{c.moveTo(i[0].x,i[0].y);let a=0;if(x.type==="curve"){for(let e=0;e<i.length;e++){let t=i[e];if(a==0&&t.x>g){c.moveTo(t.x,t.y);a=1}if(e>0&&t.x>g&&t.x<u){var r=createCurveControlPoints(i,e-1);c.bezierCurveTo(r.ctrA.x,r.ctrA.y,r.ctrB.x,r.ctrB.y,t.x,t.y)}}}if(x.type==="straight"){for(let e=0;e<i.length;e++){let t=i[e];if(a==0&&t.x>g){c.moveTo(t.x,t.y);a=1}if(e>0&&t.x>g&&t.x<u){c.lineTo(t.x,t.y)}}}if(x.type==="step"){for(let e=0;e<i.length;e++){let t=i[e];if(a==0&&t.x>g){c.moveTo(t.x,t.y);a=1}if(e>0&&t.x>g&&t.x<u){c.lineTo(t.x,i[e-1].y);c.lineTo(t.x,t.y)}}}c.moveTo(i[0].x,i[0].y)}});c.stroke();c.setLineDash([]);if(s.dataPointShape!==false){drawPointShape(n,e.color,e.pointShape,c,s)}});if(s.dataLabel!==false&&d===1){t.forEach(function(t,e){let a,i,r;a=[].concat(s.chartData.yAxisData.ranges[t.index]);i=a.pop();r=a.shift();var o=t.data;var n=getDataPoints(o,i,r,f,p,s,h,d);drawPointText(n,t,h,c,s)})}c.restore();return{xAxisPoints:f,calPoints:y,eachSpacing:p}}function drawMixDataPoints(t,v,m,T){let D=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;let e=v.chartData.xAxisData,b=e.xAxisPoints,P=e.eachSpacing;let w=assign({},{width:P/2,barBorderCircle:false,barBorderRadius:[],seriesGap:2,linearType:"none",linearOpacity:1,customColor:[],colorStop:0},v.extra.mix.column);let S=assign({},{opacity:.2,gradient:false},v.extra.mix.area);let M=v.height-v.area[2];let L=[];var _=0;var F=0;t.forEach(function(t,e){if(t.type=="column"){F+=1}});T.save();let k=-2;let R=b.length+2;let A=0;let C=v.width+P;if(v._scrollDistance_&&v._scrollDistance_!==0&&v.enableScroll===true){T.translate(v._scrollDistance_,0);k=Math.floor(-v._scrollDistance_/P)-2;R=k+v.xAxis.itemCount+4;A=-v._scrollDistance_-P*2+v.area[3];C=A+(v.xAxis.itemCount+4)*P}w.customColor=fillCustomColor(w.linearType,w.customColor,t,m);t.forEach(function(n,t){let o,x,f;o=[].concat(v.chartData.yAxisData.ranges[n.index]);x=o.pop();f=o.shift();var p=n.data;var a=getDataPoints(p,x,f,b,P,v,m,D);L.push(a);if(n.type=="column"){a=fixColumeData(a,P,F,_,m,v);for(let t=0;t<a.length;t++){let o=a[t];if(o!==null&&t>k&&t<R){var l=o.x-o.width/2;var s=v.height-o.y-v.area[2];T.beginPath();var e=o.color||n.color;var g=o.color||n.color;if(w.linearType!=="none"){var i=T.createLinearGradient(l,o.y,l,v.height-v.area[2]);if(w.linearType=="opacity"){i.addColorStop(0,hexToRgb(e,w.linearOpacity));i.addColorStop(1,hexToRgb(e,1))}else{i.addColorStop(0,hexToRgb(w.customColor[n.linearIndex],w.linearOpacity));i.addColorStop(w.colorStop,hexToRgb(w.customColor[n.linearIndex],w.linearOpacity));i.addColorStop(1,hexToRgb(e,1))}e=i}if(w.barBorderRadius&&w.barBorderRadius.length===4||w.barBorderCircle){const h=l;const c=o.y;const d=o.width;const s=v.height-v.area[2]-o.y;if(w.barBorderCircle){w.barBorderRadius=[d/2,d/2,0,0]}let[t,e,a,i]=w.barBorderRadius;let r=Math.min(d/2,s/2);t=t>r?r:t;e=e>r?r:e;a=a>r?r:a;i=i>r?r:i;t=t<0?0:t;e=e<0?0:e;a=a<0?0:a;i=i<0?0:i;T.arc(h+t,c+t,t,-Math.PI,-Math.PI/2);T.arc(h+d-e,c+e,e,-Math.PI/2,0);T.arc(h+d-a,c+s-a,a,0,Math.PI/2);T.arc(h+i,c+s-i,i,Math.PI/2,Math.PI)}else{T.moveTo(l,o.y);T.lineTo(l+o.width,o.y);T.lineTo(l+o.width,v.height-v.area[2]);T.lineTo(l,v.height-v.area[2]);T.lineTo(l,o.y);T.setLineWidth(1);T.setStrokeStyle(g)}T.setFillStyle(e);T.closePath();T.fill()}}_+=1}if(n.type=="area"){let e=splitPoints(a,n);for(let t=0;t<e.length;t++){let i=e[t];T.beginPath();T.setStrokeStyle(n.color);T.setStrokeStyle(hexToRgb(n.color,S.opacity));if(S.gradient){let t=T.createLinearGradient(0,v.area[0],0,v.height-v.area[2]);t.addColorStop("0",hexToRgb(n.color,S.opacity));t.addColorStop("1.0",hexToRgb("#FFFFFF",.1));T.setFillStyle(t)}else{T.setFillStyle(hexToRgb(n.color,S.opacity))}T.setLineWidth(2*v.pix);if(i.length>1){var r=i[0];let t=i[i.length-1];T.moveTo(r.x,r.y);let a=0;if(n.style==="curve"){for(let e=0;e<i.length;e++){let t=i[e];if(a==0&&t.x>A){T.moveTo(t.x,t.y);a=1}if(e>0&&t.x>A&&t.x<C){var u=createCurveControlPoints(i,e-1);T.bezierCurveTo(u.ctrA.x,u.ctrA.y,u.ctrB.x,u.ctrB.y,t.x,t.y)}}}else{for(let e=0;e<i.length;e++){let t=i[e];if(a==0&&t.x>A){T.moveTo(t.x,t.y);a=1}if(e>0&&t.x>A&&t.x<C){T.lineTo(t.x,t.y)}}}T.lineTo(t.x,M);T.lineTo(r.x,M);T.lineTo(r.x,r.y)}else{let t=i[0];T.moveTo(t.x-P/2,t.y);T.lineTo(t.x+P/2,t.y);T.lineTo(t.x+P/2,M);T.lineTo(t.x-P/2,M);T.moveTo(t.x-P/2,t.y)}T.closePath();T.fill()}}if(n.type=="line"){var y=splitPoints(a,n);y.forEach(function(i,t){if(n.lineType=="dash"){let t=n.dashLength?n.dashLength:8;t*=v.pix;T.setLineDash([t,t])}T.beginPath();T.setStrokeStyle(n.color);T.setLineWidth(2*v.pix);if(i.length===1){T.moveTo(i[0].x,i[0].y);T.arc(i[0].x,i[0].y,1,0,2*Math.PI)}else{T.moveTo(i[0].x,i[0].y);let a=0;if(n.style=="curve"){for(let e=0;e<i.length;e++){let t=i[e];if(a==0&&t.x>A){T.moveTo(t.x,t.y);a=1}if(e>0&&t.x>A&&t.x<C){var r=createCurveControlPoints(i,e-1);T.bezierCurveTo(r.ctrA.x,r.ctrA.y,r.ctrB.x,r.ctrB.y,t.x,t.y)}}}else{for(let e=0;e<i.length;e++){let t=i[e];if(a==0&&t.x>A){T.moveTo(t.x,t.y);a=1}if(e>0&&t.x>A&&t.x<C){T.lineTo(t.x,t.y)}}}T.moveTo(i[0].x,i[0].y)}T.stroke();T.setLineDash([])})}if(n.type=="point"){n.addPoint=true}if(n.addPoint==true&&n.type!=="column"){drawPointShape(a,n.color,n.pointShape,T,v)}});if(v.dataLabel!==false&&D===1){var _=0;t.forEach(function(t,e){let a,i,r;a=[].concat(v.chartData.yAxisData.ranges[t.index]);i=a.pop();r=a.shift();var o=t.data;var n=getDataPoints(o,i,r,b,P,v,m,D);if(t.type!=="column"){drawPointText(n,t,m,T,v)}else{n=fixColumeData(n,P,F,_,m,v);drawPointText(n,t,m,T,v);_+=1}})}T.restore();return{xAxisPoints:b,calPoints:L,eachSpacing:P}}function drawToolTipBridge(t,e,a,i,r,o){var n=t.extra.tooltip||{};if(n.horizentalLine&&t.tooltip&&i===1&&(t.type=="line"||t.type=="area"||t.type=="column"||t.type=="mount"||t.type=="candle"||t.type=="mix")){drawToolTipHorizentalLine(t,e,a,r,o)}a.save();if(t._scrollDistance_&&t._scrollDistance_!==0&&t.enableScroll===true){a.translate(t._scrollDistance_,0)}if(t.tooltip&&t.tooltip.textList&&t.tooltip.textList.length&&i===1){drawToolTip(t.tooltip.textList,t.tooltip.offset,t,e,a,r,o)}a.restore()}function drawXAxis(r,l,s,h){let t=l.chartData.xAxisData,c=t.xAxisPoints,e=t.startX,a=t.endX,d=t.eachSpacing;var p="center";if(l.type=="bar"||l.type=="line"||l.type=="area"||l.type=="scatter"||l.type=="bubble"){p=l.xAxis.boundaryGap}var x=l.height-l.area[2];var i=l.area[0];if(l.enableScroll&&l.xAxis.scrollShow){var o=l.height-l.area[2]+s.xAxisHeight;var n=a-e;var g=d*(c.length-1);if(l.type=="mount"&&l.extra&&l.extra.mount&&l.extra.mount.widthRatio&&l.extra.mount.widthRatio>1){if(l.extra.mount.widthRatio>2)l.extra.mount.widthRatio=2;g+=(l.extra.mount.widthRatio-1)*d}var u=n*n/g;var y=0;if(l._scrollDistance_){y=-l._scrollDistance_*n/g}h.beginPath();h.setLineCap("round");h.setLineWidth(6*l.pix);h.setStrokeStyle(l.xAxis.scrollBackgroundColor||"#EFEBEF");h.moveTo(e,o);h.lineTo(a,o);h.stroke();h.closePath();h.beginPath();h.setLineCap("round");h.setLineWidth(6*l.pix);h.setStrokeStyle(l.xAxis.scrollColor||"#A6A6A6");h.moveTo(e+y,o);h.lineTo(e+y+u,o);h.stroke();h.closePath();h.setLineCap("butt")}h.save();if(l._scrollDistance_&&l._scrollDistance_!==0){h.translate(l._scrollDistance_,0)}if(l.xAxis.calibration===true){h.setStrokeStyle(l.xAxis.gridColor||"#cccccc");h.setLineCap("butt");h.setLineWidth(1*l.pix);c.forEach(function(t,e){if(e>0){h.beginPath();h.moveTo(t-d/2,x);h.lineTo(t-d/2,x+3*l.pix);h.closePath();h.stroke()}})}if(l.xAxis.disableGrid!==true){h.setStrokeStyle(l.xAxis.gridColor||"#cccccc");h.setLineCap("butt");h.setLineWidth(1*l.pix);if(l.xAxis.gridType=="dash"){h.setLineDash([l.xAxis.dashLength*l.pix,l.xAxis.dashLength*l.pix])}l.xAxis.gridEval=l.xAxis.gridEval||1;c.forEach(function(t,e){if(e%l.xAxis.gridEval==0){h.beginPath();h.moveTo(t,x);h.lineTo(t,i);h.stroke()}});h.setLineDash([])}if(l.xAxis.disabled!==true){let t=r.length;if(l.xAxis.labelCount){if(l.xAxis.itemCount){t=Math.ceil(r.length/l.xAxis.itemCount*l.xAxis.labelCount)}else{t=l.xAxis.labelCount}t-=1}let e=Math.ceil(r.length/t);let a=[];let i=r.length;for(let t=0;t<i;t++){if(t%e!==0){a.push("")}else{a.push(r[t])}}a[i-1]=r[i-1];var f=l.xAxis.fontSize*l.pix||s.fontSize;if(s._xAxisTextAngle_===0){a.forEach(function(t,e){var a=l.xAxis.formatter?l.xAxis.formatter(t,e,l):t;var i=-measureText(String(a),f,h)/2;if(p=="center"){i+=d/2}var r=0;if(l.xAxis.scrollShow){r=6*l.pix}h.beginPath();h.setFontSize(f);h.setFillStyle(l.xAxis.fontColor||l.fontColor);h.fillText(String(a),c[e]+i,x+f+(s.xAxisHeight-r-f)/2);h.closePath();h.stroke()})}else{a.forEach(function(t,e){var a=l.xAxis.formatter?l.xAxis.formatter(t):t;h.save();h.beginPath();h.setFontSize(f);h.setFillStyle(l.xAxis.fontColor||l.fontColor);var i=measureText(String(a),f,h);var r=c[e];if(p=="center"){r=c[e]+d/2}var o=0;if(l.xAxis.scrollShow){o=6*l.pix}var n=x+6*l.pix+f-f*Math.abs(Math.sin(s._xAxisTextAngle_));if(l.xAxis.rotateAngle<0){r-=f/2;i=0}else{r+=f/2;i=-i}h.translate(r,n);h.rotate(-1*s._xAxisTextAngle_);h.fillText(String(a),i,0);h.closePath();h.stroke();h.restore()})}}h.restore();if(l.xAxis.axisLine){h.beginPath();h.setStrokeStyle(l.xAxis.axisLineColor);h.setLineWidth(1*l.pix);h.moveTo(e,l.height-l.area[2]);h.lineTo(a,l.height-l.area[2]);h.stroke()}}function drawYAxisGrid(c,e,d,a){if(e.yAxis.disableGrid===true){return}let t=e.height-e.area[0]-e.area[2];let i=t/e.yAxis.splitNumber;let r=e.area[3];let o=e.chartData.xAxisData.xAxisPoints,n=e.chartData.xAxisData.eachSpacing;let l=n*(o.length-1);if(e.type=="mount"&&e.extra&&e.extra.mount&&e.extra.mount.widthRatio&&e.extra.mount.widthRatio>1){if(e.extra.mount.widthRatio>2)e.extra.mount.widthRatio=2;l+=(e.extra.mount.widthRatio-1)*n}let x=r+l;let s=[];let h=1;if(e.xAxis.axisLine===false){h=0}for(let t=h;t<e.yAxis.splitNumber+1;t++){s.push(e.height-e.area[2]-i*t)}a.save();if(e._scrollDistance_&&e._scrollDistance_!==0){a.translate(e._scrollDistance_,0)}if(e.yAxis.gridType=="dash"){a.setLineDash([e.yAxis.dashLength*e.pix,e.yAxis.dashLength*e.pix])}a.setStrokeStyle(e.yAxis.gridColor);a.setLineWidth(1*e.pix);s.forEach(function(t,e){a.beginPath();a.moveTo(r,t);a.lineTo(x,t);a.stroke()});a.setLineDash([]);a.restore()}function drawYAxis(e,h,a,c){if(h.yAxis.disabled===true){return}var i=h.height-h.area[0]-h.area[2];var r=i/h.yAxis.splitNumber;var o=h.area[3];var n=h.width-h.area[1];var l=h.height-h.area[2];var t=l+a.xAxisHeight;if(h.xAxis.scrollShow){t-=3*h.pix}if(h.xAxis.rotateLabel){t=h.height-h.area[2]+h.fontSize*h.pix/2}c.beginPath();c.setFillStyle(h.background);if(h.enableScroll==true&&h.xAxis.scrollPosition&&h.xAxis.scrollPosition!=="left"){c.fillRect(0,0,o,t)}if(h.enableScroll==true&&h.xAxis.scrollPosition&&h.xAxis.scrollPosition!=="right"){c.fillRect(n,0,h.width,t)}c.closePath();c.stroke();let d=h.area[3];let x=h.width-h.area[1];let f=h.area[3]+(h.width-h.area[1]-h.area[3])/2;if(h.yAxis.data){for(let e=0;e<h.yAxis.data.length;e++){let s=h.yAxis.data[e];var p=[];if(s.type==="categories"){for(let t=0;t<=s.categories.length;t++){p.push(h.area[0]+i/s.categories.length/2+i/s.categories.length*t)}}else{for(let t=0;t<=h.yAxis.splitNumber;t++){p.push(h.area[0]+r*t)}}if(s.disabled!==true){let t=h.chartData.yAxisData.rangesFormat[e];let o=s.fontSize?s.fontSize*h.pix:a.fontSize;let n=h.chartData.yAxisData.yAxisWidth[e];let l=s.textAlign||"right";t.forEach(function(t,e){var a=p[e];c.beginPath();c.setFontSize(o);c.setLineWidth(1*h.pix);c.setStrokeStyle(s.axisLineColor||"#cccccc");c.setFillStyle(s.fontColor||h.fontColor);let i=0;let r=4*h.pix;if(n.position=="left"){if(s.calibration==true){c.moveTo(d,a);c.lineTo(d-3*h.pix,a);r+=3*h.pix}switch(l){case"left":c.setTextAlign("left");i=d-n.width;break;case"right":c.setTextAlign("right");i=d-r;break;default:c.setTextAlign("center");i=d-n.width/2}c.fillText(String(t),i,a+o/2-3*h.pix)}else if(n.position=="right"){if(s.calibration==true){c.moveTo(x,a);c.lineTo(x+3*h.pix,a);r+=3*h.pix}switch(l){case"left":c.setTextAlign("left");i=x+r;break;case"right":c.setTextAlign("right");i=x+n.width;break;default:c.setTextAlign("center");i=x+n.width/2}c.fillText(String(t),i,a+o/2-3*h.pix)}else if(n.position=="center"){if(s.calibration==true){c.moveTo(f,a);c.lineTo(f-3*h.pix,a);r+=3*h.pix}switch(l){case"left":c.setTextAlign("left");i=f-n.width;break;case"right":c.setTextAlign("right");i=f-r;break;default:c.setTextAlign("center");i=f-n.width/2}c.fillText(String(t),i,a+o/2-3*h.pix)}c.closePath();c.stroke();c.setTextAlign("left")});if(s.axisLine!==false){c.beginPath();c.setStrokeStyle(s.axisLineColor||"#cccccc");c.setLineWidth(1*h.pix);if(n.position=="left"){c.moveTo(d,h.height-h.area[2]);c.lineTo(d,h.area[0])}else if(n.position=="right"){c.moveTo(x,h.height-h.area[2]);c.lineTo(x,h.area[0])}else if(n.position=="center"){c.moveTo(f,h.height-h.area[2]);c.lineTo(f,h.area[0])}c.stroke()}if(h.yAxis.showTitle){let t=s.titleFontSize*h.pix||a.fontSize;let e=s.title;c.beginPath();c.setFontSize(t);c.setFillStyle(s.titleFontColor||h.fontColor);if(n.position=="left"){c.fillText(e,d-measureText(e,t,c)/2+(s.titleOffsetX||0),h.area[0]-(10-(s.titleOffsetY||0))*h.pix)}else if(n.position=="right"){c.fillText(e,x-measureText(e,t,c)/2+(s.titleOffsetX||0),h.area[0]-(10-(s.titleOffsetY||0))*h.pix)}else if(n.position=="center"){c.fillText(e,f-measureText(e,t,c)/2+(s.titleOffsetX||0),h.area[0]-(10-(s.titleOffsetY||0))*h.pix)}c.closePath();c.stroke()}if(n.position=="left"){d-=n.width+h.yAxis.padding*h.pix}else{x+=n.width+h.yAxis.padding*h.pix}}}}}function drawLegend(t,l,y,s,e){if(l.legend.show===false){return}let h=e.legendData;let a=h.points;let c=h.area;let d=l.legend.padding*l.pix;let x=l.legend.fontSize*l.pix;let f=15*l.pix;let p=5*l.pix;let g=l.legend.itemGap*l.pix;let u=Math.max(l.legend.lineHeight*l.pix,x);s.beginPath();s.setLineWidth(l.legend.borderWidth*l.pix);s.setStrokeStyle(l.legend.borderColor);s.setFillStyle(l.legend.backgroundColor);s.moveTo(c.start.x,c.start.y);s.rect(c.start.x,c.start.y,c.width,c.height);s.closePath();s.fill();s.stroke();a.forEach(function(i,t){let e=0;let a=0;e=h.widthArr[t];a=h.heightArr[t];let r=0;let o=0;if(l.legend.position=="top"||l.legend.position=="bottom"){switch(l.legend.float){case"left":r=c.start.x+d;break;case"right":r=c.start.x+c.width-e;break;default:r=c.start.x+(c.width-e)/2}o=c.start.y+d+t*u}else{if(t==0){e=0}else{e=h.widthArr[t-1]}r=c.start.x+d+e;o=c.start.y+d+(c.height-a)/2}s.setFontSize(y.fontSize);for(let a=0;a<i.length;a++){let t=i[a];t.area=[0,0,0,0];t.area[0]=r;t.area[1]=o;t.area[3]=o+u;s.beginPath();s.setLineWidth(1*l.pix);s.setStrokeStyle(t.show?t.color:l.legend.hiddenColor);s.setFillStyle(t.show?t.color:l.legend.hiddenColor);switch(t.legendShape){case"line":s.moveTo(r,o+.5*u-2*l.pix);s.fillRect(r,o+.5*u-2*l.pix,15*l.pix,4*l.pix);break;case"triangle":s.moveTo(r+7.5*l.pix,o+.5*u-5*l.pix);s.lineTo(r+2.5*l.pix,o+.5*u+5*l.pix);s.lineTo(r+12.5*l.pix,o+.5*u+5*l.pix);s.lineTo(r+7.5*l.pix,o+.5*u-5*l.pix);break;case"diamond":s.moveTo(r+7.5*l.pix,o+.5*u-5*l.pix);s.lineTo(r+2.5*l.pix,o+.5*u);s.lineTo(r+7.5*l.pix,o+.5*u+5*l.pix);s.lineTo(r+12.5*l.pix,o+.5*u);s.lineTo(r+7.5*l.pix,o+.5*u-5*l.pix);break;case"circle":s.moveTo(r+7.5*l.pix,o+.5*u);s.arc(r+7.5*l.pix,o+.5*u,5*l.pix,0,2*Math.PI);break;case"rect":s.moveTo(r,o+.5*u-5*l.pix);s.fillRect(r,o+.5*u-5*l.pix,15*l.pix,10*l.pix);break;case"square":s.moveTo(r+5*l.pix,o+.5*u-5*l.pix);s.fillRect(r+5*l.pix,o+.5*u-5*l.pix,10*l.pix,10*l.pix);break;case"none":break;default:s.moveTo(r,o+.5*u-5*l.pix);s.fillRect(r,o+.5*u-5*l.pix,15*l.pix,10*l.pix)}s.closePath();s.fill();s.stroke();r+=f+p;let e=.5*u+.5*x-2;const n=t.legendText?t.legendText:t.name;s.beginPath();s.setFontSize(x);s.setFillStyle(t.show?l.legend.fontColor:l.legend.hiddenColor);s.fillText(n,r,o+e);s.closePath();s.stroke();if(l.legend.position=="top"||l.legend.position=="bottom"){r+=measureText(n,x,s)+g;t.area[2]=r}else{t.area[2]=r+measureText(n,x,s)+g;r-=f+p;o+=u}}})}function drawPieDataPoints(t,r,e,o){var a=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;var n=assign({},{activeOpacity:.5,activeRadius:10,offsetAngle:0,labelWidth:15,ringWidth:30,customRadius:0,border:false,borderWidth:2,borderColor:"#FFFFFF",centerColor:"#FFFFFF",linearType:"none",customColor:[]},r.type=="pie"?r.extra.pie:r.extra.ring);var l={x:r.area[3]+(r.width-r.area[1]-r.area[3])/2,y:r.area[0]+(r.height-r.area[0]-r.area[2])/2};if(e.pieChartLinePadding==0){e.pieChartLinePadding=n.activeRadius*r.pix}var i=Math.min((r.width-r.area[1]-r.area[3])/2-e.pieChartLinePadding-e.pieChartTextPadding-e._pieTextMaxLength_,(r.height-r.area[0]-r.area[2])/2-e.pieChartLinePadding-e.pieChartTextPadding);i=i<10?10:i;if(n.customRadius>0){i=n.customRadius*r.pix}t=getPieDataPoints(t,i,a);var h=n.activeRadius*r.pix;n.customColor=fillCustomColor(n.linearType,n.customColor,t,e);t=t.map(function(t){t._start_+=n.offsetAngle*Math.PI/180;return t});t.forEach(function(t,e){if(r.tooltip){if(r.tooltip.index==e){o.beginPath();o.setFillStyle(hexToRgb(t.color,n.activeOpacity||.5));o.moveTo(l.x,l.y);o.arc(l.x,l.y,t._radius_+h,t._start_,t._start_+2*t._proportion_*Math.PI);o.closePath();o.fill()}}o.beginPath();o.setLineWidth(n.borderWidth*r.pix);o.lineJoin="round";o.setStrokeStyle(n.borderColor);var a=t.color;if(n.linearType=="custom"){var i;if(o.createCircularGradient){i=o.createCircularGradient(l.x,l.y,t._radius_)}else{i=o.createRadialGradient(l.x,l.y,0,l.x,l.y,t._radius_)}i.addColorStop(0,hexToRgb(n.customColor[t.linearIndex],1));i.addColorStop(1,hexToRgb(t.color,1));a=i}o.setFillStyle(a);o.moveTo(l.x,l.y);o.arc(l.x,l.y,t._radius_,t._start_,t._start_+2*t._proportion_*Math.PI);o.closePath();o.fill();if(n.border==true){o.stroke()}});if(r.type==="ring"){var s=i*.6;if(typeof n.ringWidth==="number"&&n.ringWidth>0){s=Math.max(0,i-n.ringWidth*r.pix)}o.beginPath();o.setFillStyle(n.centerColor);o.moveTo(l.x,l.y);o.arc(l.x,l.y,s,0,2*Math.PI);o.closePath();o.fill()}if(r.dataLabel!==false&&a===1){drawPieText(t,r,e,o,i,l)}if(a===1&&r.type==="ring"){drawRingTitle(r,e,o,l)}return{center:l,radius:i,series:t}}function drawRoseDataPoints(t,r,e,o){var a=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;var n=assign({},{type:"area",activeOpacity:.5,activeRadius:10,offsetAngle:0,labelWidth:15,border:false,borderWidth:2,borderColor:"#FFFFFF",linearType:"none",customColor:[]},r.extra.rose);if(e.pieChartLinePadding==0){e.pieChartLinePadding=n.activeRadius*r.pix}var l={x:r.area[3]+(r.width-r.area[1]-r.area[3])/2,y:r.area[0]+(r.height-r.area[0]-r.area[2])/2};var i=Math.min((r.width-r.area[1]-r.area[3])/2-e.pieChartLinePadding-e.pieChartTextPadding-e._pieTextMaxLength_,(r.height-r.area[0]-r.area[2])/2-e.pieChartLinePadding-e.pieChartTextPadding);i=i<10?10:i;var s=n.minRadius||i*.5;t=getRoseDataPoints(t,n.type,s,i,a);var h=n.activeRadius*r.pix;n.customColor=fillCustomColor(n.linearType,n.customColor,t,e);t=t.map(function(t){t._start_+=(n.offsetAngle||0)*Math.PI/180;return t});t.forEach(function(t,e){if(r.tooltip){if(r.tooltip.index==e){o.beginPath();o.setFillStyle(hexToRgb(t.color,n.activeOpacity||.5));o.moveTo(l.x,l.y);o.arc(l.x,l.y,h+t._radius_,t._start_,t._start_+2*t._rose_proportion_*Math.PI);o.closePath();o.fill()}}o.beginPath();o.setLineWidth(n.borderWidth*r.pix);o.lineJoin="round";o.setStrokeStyle(n.borderColor);var a=t.color;if(n.linearType=="custom"){var i;if(o.createCircularGradient){i=o.createCircularGradient(l.x,l.y,t._radius_)}else{i=o.createRadialGradient(l.x,l.y,0,l.x,l.y,t._radius_)}i.addColorStop(0,hexToRgb(n.customColor[t.linearIndex],1));i.addColorStop(1,hexToRgb(t.color,1));a=i}o.setFillStyle(a);o.moveTo(l.x,l.y);o.arc(l.x,l.y,t._radius_,t._start_,t._start_+2*t._rose_proportion_*Math.PI);o.closePath();o.fill();if(n.border==true){o.stroke()}});if(r.dataLabel!==false&&a===1){drawPieText(t,r,e,o,i,l)}return{center:l,radius:i,series:t}}function drawArcbarDataPoints(a,i,t,r){var e=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;var o=assign({},{startAngle:.75,endAngle:.25,type:"default",lineCap:"round",width:12,gap:2,linearType:"none",customColor:[]},i.extra.arcbar);a=getArcbarDataPoints(a,o,e);var n;if(o.centerX||o.centerY){n={x:o.centerX?o.centerX:i.width/2,y:o.centerY?o.centerY:i.height/2}}else{n={x:i.width/2,y:i.height/2}}var l;if(o.radius){l=o.radius}else{l=Math.min(n.x,n.y);l-=5*i.pix;l-=o.width/2}l=l<10?10:l;o.customColor=fillCustomColor(o.linearType,o.customColor,a,t);for(let e=0;e<a.length;e++){let t=a[e];r.setLineWidth(o.width*i.pix);r.setStrokeStyle(o.backgroundColor||"#E9E9E9");r.setLineCap(o.lineCap);r.beginPath();if(o.type=="default"){r.arc(n.x,n.y,l-(o.width*i.pix+o.gap*i.pix)*e,o.startAngle*Math.PI,o.endAngle*Math.PI,false)}else{r.arc(n.x,n.y,l-(o.width*i.pix+o.gap*i.pix)*e,0,2*Math.PI,false)}r.stroke();var s=t.color;if(o.linearType=="custom"){var h=r.createLinearGradient(n.x-l,n.y,n.x+l,n.y);h.addColorStop(1,hexToRgb(o.customColor[t.linearIndex],1));h.addColorStop(0,hexToRgb(t.color,1));s=h}r.setLineWidth(o.width*i.pix);r.setStrokeStyle(s);r.setLineCap(o.lineCap);r.beginPath();r.arc(n.x,n.y,l-(o.width*i.pix+o.gap*i.pix)*e,o.startAngle*Math.PI,t._proportion_*Math.PI,false);r.stroke()}drawRingTitle(i,t,r,n);return{center:n,radius:l,series:a}}function drawGaugeDataPoints(n,h,c,t,d){var x=arguments.length>5&&arguments[5]!==undefined?arguments[5]:1;var f=assign({},{type:"default",startAngle:.75,endAngle:.25,width:15,labelOffset:13,splitLine:{fixRadius:0,splitNumber:10,width:15,color:"#FFFFFF",childNumber:5,childWidth:5},pointer:{width:15,color:"auto"}},c.extra.gauge);if(f.oldAngle==undefined){f.oldAngle=f.startAngle}if(f.oldData==undefined){f.oldData=0}n=getGaugeAxisPoints(n,f.startAngle,f.endAngle);var p={x:c.width/2,y:c.height/2};var g=Math.min(p.x,p.y);g-=5*c.pix;g-=f.width/2;g=g<10?10:g;var u=g-f.width;var y=0;if(f.type=="progress"){var v=g-f.width*3;d.beginPath();let t=d.createLinearGradient(p.x,p.y-v,p.x,p.y+v);t.addColorStop("0",hexToRgb(h[0].color,.3));t.addColorStop("1.0",hexToRgb("#FFFFFF",.1));d.setFillStyle(t);d.arc(p.x,p.y,v,0,2*Math.PI,false);d.fill();d.setLineWidth(f.width);d.setStrokeStyle(hexToRgb(h[0].color,.3));d.setLineCap("round");d.beginPath();d.arc(p.x,p.y,u,f.startAngle*Math.PI,f.endAngle*Math.PI,false);d.stroke();y=f.startAngle-f.endAngle+1;let e=y/f.splitLine.splitNumber;let a=y/f.splitLine.splitNumber/f.splitLine.childNumber;let i=-g-f.width*.5-f.splitLine.fixRadius;let r=-g-f.width-f.splitLine.fixRadius+f.splitLine.width;d.save();d.translate(p.x,p.y);d.rotate((f.startAngle-1)*Math.PI);let o=f.splitLine.splitNumber*f.splitLine.childNumber+1;let n=h[0].data*x;for(let t=0;t<o;t++){d.beginPath();if(n>t/o){d.setStrokeStyle(hexToRgb(h[0].color,1))}else{d.setStrokeStyle(hexToRgb(h[0].color,.3))}d.setLineWidth(3*c.pix);d.moveTo(i,0);d.lineTo(r,0);d.stroke();d.rotate(a*Math.PI)}d.restore();h=getGaugeArcbarDataPoints(h,f,x);d.setLineWidth(f.width);d.setStrokeStyle(h[0].color);d.setLineCap("round");d.beginPath();d.arc(p.x,p.y,u,f.startAngle*Math.PI,h[0]._proportion_*Math.PI,false);d.stroke();let l=g-f.width*2.5;d.save();d.translate(p.x,p.y);d.rotate((h[0]._proportion_-1)*Math.PI);d.beginPath();d.setLineWidth(f.width/3);let s=d.createLinearGradient(0,-l*.6,0,l*.6);s.addColorStop("0",hexToRgb("#FFFFFF",0));s.addColorStop("0.5",hexToRgb(h[0].color,1));s.addColorStop("1.0",hexToRgb("#FFFFFF",0));d.setStrokeStyle(s);d.arc(0,0,l,.85*Math.PI,1.15*Math.PI,false);d.stroke();d.beginPath();d.setLineWidth(1);d.setStrokeStyle(h[0].color);d.setFillStyle(h[0].color);d.moveTo(-l-f.width/3/2,-4);d.lineTo(-l-f.width/3/2-4,0);d.lineTo(-l-f.width/3/2,4);d.lineTo(-l-f.width/3/2,-4);d.stroke();d.fill();d.restore()}else{d.setLineWidth(f.width);d.setLineCap("butt");for(let e=0;e<n.length;e++){let t=n[e];d.beginPath();d.setStrokeStyle(t.color);d.arc(p.x,p.y,g,t._startAngle_*Math.PI,t._endAngle_*Math.PI,false);d.stroke()}d.save();y=f.startAngle-f.endAngle+1;let e=y/f.splitLine.splitNumber;let a=y/f.splitLine.splitNumber/f.splitLine.childNumber;let i=-g-f.width*.5-f.splitLine.fixRadius;let r=-g-f.width*.5-f.splitLine.fixRadius+f.splitLine.width;let o=-g-f.width*.5-f.splitLine.fixRadius+f.splitLine.childWidth;d.translate(p.x,p.y);d.rotate((f.startAngle-1)*Math.PI);for(let t=0;t<f.splitLine.splitNumber+1;t++){d.beginPath();d.setStrokeStyle(f.splitLine.color);d.setLineWidth(2*c.pix);d.moveTo(i,0);d.lineTo(r,0);d.stroke();d.rotate(e*Math.PI)}d.restore();d.save();d.translate(p.x,p.y);d.rotate((f.startAngle-1)*Math.PI);for(let t=0;t<f.splitLine.splitNumber*f.splitLine.childNumber+1;t++){d.beginPath();d.setStrokeStyle(f.splitLine.color);d.setLineWidth(1*c.pix);d.moveTo(i,0);d.lineTo(o,0);d.stroke();d.rotate(a*Math.PI)}d.restore();h=getGaugeDataPoints(h,n,f,x);for(let e=0;e<h.length;e++){let t=h[e];d.save();d.translate(p.x,p.y);d.rotate((t._proportion_-1)*Math.PI);d.beginPath();d.setFillStyle(t.color);d.moveTo(f.pointer.width,0);d.lineTo(0,-f.pointer.width/2);d.lineTo(-u,0);d.lineTo(0,f.pointer.width/2);d.lineTo(f.pointer.width,0);d.closePath();d.fill();d.beginPath();d.setFillStyle("#FFFFFF");d.arc(0,0,f.pointer.width/6,0,2*Math.PI,false);d.fill();d.restore()}if(c.dataLabel!==false){drawGaugeLabel(f,g,p,c,t,d)}}drawRingTitle(c,t,d,p);if(x===1&&c.type==="gauge"){c.extra.gauge.oldAngle=h[0]._proportion_;c.extra.gauge.oldData=h[0].data}return{center:p,radius:g,innerRadius:u,categories:n,totalAngle:y}}function drawRadarDataPoints(o,n,i,l){var t=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;var s=assign({},{gridColor:"#cccccc",gridType:"radar",gridEval:1,axisLabel:false,axisLabelTofix:0,labelColor:"#666666",labelPointShow:false,labelPointRadius:3,labelPointColor:"#cccccc",opacity:.2,gridCount:3,border:false,borderWidth:2,linearType:"none",customColor:[]},n.extra.radar);var a=getRadarCoordinateSeries(n.categories.length);var h={x:n.area[3]+(n.width-n.area[1]-n.area[3])/2,y:n.area[0]+(n.height-n.area[0]-n.area[2])/2};var r=(n.width-n.area[1]-n.area[3])/2;var d=(n.height-n.area[0]-n.area[2])/2;var c=Math.min(r-(getMaxTextListLength(n.categories,i.fontSize,l)+i.radarLabelTextMargin),d-i.radarLabelTextMargin);c-=i.radarLabelTextMargin*n.pix;c=c<10?10:c;l.beginPath();l.setLineWidth(1*n.pix);l.setStrokeStyle(s.gridColor);a.forEach(function(t,e){var a=convertCoordinateOrigin(c*Math.cos(t),c*Math.sin(t),h);l.moveTo(h.x,h.y);if(e%s.gridEval==0){l.lineTo(a.x,a.y)}});l.stroke();l.closePath();var x=function t(i){var r={};l.beginPath();l.setLineWidth(1*n.pix);l.setStrokeStyle(s.gridColor);if(s.gridType=="radar"){a.forEach(function(t,e){var a=convertCoordinateOrigin(c/s.gridCount*i*Math.cos(t),c/s.gridCount*i*Math.sin(t),h);if(e===0){r=a;l.moveTo(a.x,a.y)}else{l.lineTo(a.x,a.y)}});l.lineTo(r.x,r.y)}else{var e=convertCoordinateOrigin(c/s.gridCount*i*Math.cos(1.5),c/s.gridCount*i*Math.sin(1.5),h);l.arc(h.x,h.y,h.y-e.y,0,2*Math.PI,false)}l.stroke();l.closePath()};for(var e=1;e<=s.gridCount;e++){x(e)}s.customColor=fillCustomColor(s.linearType,s.customColor,o,i);var f=getRadarDataPoints(a,h,c,o,n,t);f.forEach(function(t,e){l.beginPath();l.setLineWidth(s.borderWidth*n.pix);l.setStrokeStyle(t.color);var a=hexToRgb(t.color,s.opacity);if(s.linearType=="custom"){var i;if(l.createCircularGradient){i=l.createCircularGradient(h.x,h.y,c)}else{i=l.createRadialGradient(h.x,h.y,0,h.x,h.y,c)}i.addColorStop(0,hexToRgb(s.customColor[o[e].linearIndex],s.opacity));i.addColorStop(1,hexToRgb(t.color,s.opacity));a=i}l.setFillStyle(a);t.data.forEach(function(t,e){if(e===0){l.moveTo(t.position.x,t.position.y)}else{l.lineTo(t.position.x,t.position.y)}});l.closePath();l.fill();if(s.border===true){l.stroke()}l.closePath();if(n.dataPointShape!==false){var r=t.data.map(function(t){return t.position});drawPointShape(r,t.color,t.pointShape,l,n)}});if(s.axisLabel===true){const p=Math.max(s.max,Math.max.apply(null,dataCombine(o)));const g=c/s.gridCount;const u=n.fontSize*n.pix;l.setFontSize(u);l.setFillStyle(n.fontColor);l.setTextAlign("left");for(var e=0;e<s.gridCount+1;e++){let t=e*p/s.gridCount;t=t.toFixed(s.axisLabelTofix);l.fillText(String(t),h.x+3*n.pix,h.y-e*g+u/2)}}drawRadarLabel(a,c,h,n,i,l);if(n.dataLabel!==false&&t===1){f.forEach(function(t,e){l.beginPath();var a=t.textSize*n.pix||i.fontSize;l.setFontSize(a);l.setFillStyle(t.textColor||n.fontColor);t.data.forEach(function(t,e){if(Math.abs(t.position.x-h.x)<2){if(t.position.y<h.y){l.setTextAlign("center");l.fillText(t.value,t.position.x,t.position.y-4)}else{l.setTextAlign("center");l.fillText(t.value,t.position.x,t.position.y+a+2)}}else{if(t.position.x<h.x){l.setTextAlign("right");l.fillText(t.value,t.position.x-4,t.position.y+a/2-2)}else{l.setTextAlign("left");l.fillText(t.value,t.position.x+4,t.position.y+a/2-2)}}});l.closePath();l.stroke()});l.setTextAlign("left")}return{center:h,radius:c,angleList:a}}function lonlat2mercator(t,e){var a=Array(2);var i=t*20037508.34/180;var r=Math.log(Math.tan((90+e)*Math.PI/360))/(Math.PI/180);r=r*20037508.34/180;a[0]=i;a[1]=r;return a}function mercator2lonlat(t,e){var a=Array(2);var i=t/20037508.34*180;var r=e/20037508.34*180;r=180/Math.PI*(2*Math.atan(Math.exp(r*Math.PI/180))-Math.PI/2);a[0]=i;a[1]=r;return a}function getBoundingBox(t){var e={},a;e.xMin=180;e.xMax=0;e.yMin=90;e.yMax=0;for(var i=0;i<t.length;i++){var r=t[i].geometry.coordinates;for(var o=0;o<r.length;o++){a=r[o];if(a.length==1){a=a[0]}for(var n=0;n<a.length;n++){var l=a[n][0];var s=a[n][1];var h={x:l,y:s};e.xMin=e.xMin<h.x?e.xMin:h.x;e.xMax=e.xMax>h.x?e.xMax:h.x;e.yMin=e.yMin<h.y?e.yMin:h.y;e.yMax=e.yMax>h.y?e.yMax:h.y}}}return e}function coordinateToPoint(t,e,a,i,r,o){return{x:(e-a.xMin)*i+r,y:(a.yMax-t)*i+o}}function pointToCoordinate(t,e,a,i,r,o){return{x:(e-r)/i+a.xMin,y:a.yMax-(t-o)/i}}function isRayIntersectsSegment(t,e,a){if(e[1]==a[1]){return false}if(e[1]>t[1]&&a[1]>t[1]){return false}if(e[1]<t[1]&&a[1]<t[1]){return false}if(e[1]==t[1]&&a[1]>t[1]){return false}if(a[1]==t[1]&&e[1]>t[1]){return false}if(e[0]<t[0]&&a[1]<t[1]){return false}let i=a[0]-(a[0]-e[0])*(a[1]-t[1])/(a[1]-e[1]);if(i<t[0]){return false}else{return true}}function isPoiWithinPoly(r,e,o){let n=0;for(let t=0;t<e.length;t++){let i=e[t][0];if(e.length==1){i=e[t][0]}for(let a=0;a<i.length-1;a++){let t=i[a];let e=i[a+1];if(o){t=lonlat2mercator(i[a][0],i[a][1]);e=lonlat2mercator(i[a+1][0],i[a+1][1])}if(isRayIntersectsSegment(r,t,e)){n+=1}}}if(n%2==1){return true}else{return false}}function drawMapDataPoints(c,a,d,i){var r=assign({},{border:true,mercator:false,borderWidth:1,borderColor:"#666666",fillOpacity:.6,activeBorderColor:"#f04864",activeFillColor:"#facc14",activeFillOpacity:1},a.extra.map);var t,o;var n=c;var l=getBoundingBox(n);if(r.mercator){var x=lonlat2mercator(l.xMax,l.yMax);var f=lonlat2mercator(l.xMin,l.yMin);l.xMax=x[0];l.yMax=x[1];l.xMin=f[0];l.yMin=f[1]}var p=a.width/Math.abs(l.xMax-l.xMin);var g=a.height/Math.abs(l.yMax-l.yMin);var s=p<g?p:g;var u=a.width/2-Math.abs(l.xMax-l.xMin)/2*s;var y=a.height/2-Math.abs(l.yMax-l.yMin)/2*s;for(var h=0;h<n.length;h++){i.beginPath();i.setLineWidth(r.borderWidth*a.pix);i.setStrokeStyle(r.borderColor);i.setFillStyle(hexToRgb(c[h].color,r.fillOpacity));if(a.tooltip){if(a.tooltip.index==h){i.setStrokeStyle(r.activeBorderColor);i.setFillStyle(hexToRgb(r.activeFillColor,r.activeFillOpacity))}}var v=n[h].geometry.coordinates;for(var m=0;m<v.length;m++){t=v[m];if(t.length==1){t=t[0]}for(var e=0;e<t.length;e++){var T=Array(2);if(r.mercator){T=lonlat2mercator(t[e][0],t[e][1])}else{T=t[e]}o=coordinateToPoint(T[1],T[0],l,s,u,y);if(e===0){i.beginPath();i.moveTo(o.x,o.y)}else{i.lineTo(o.x,o.y)}}i.fill();if(r.border==true){i.stroke()}}}if(a.dataLabel==true){for(var h=0;h<n.length;h++){var b=n[h].properties.centroid;if(b){if(r.mercator){b=lonlat2mercator(n[h].properties.centroid[0],n[h].properties.centroid[1])}o=coordinateToPoint(b[1],b[0],l,s,u,y);let t=n[h].textSize*a.pix||d.fontSize;let e=n[h].properties.name;i.beginPath();i.setFontSize(t);i.setFillStyle(n[h].textColor||a.fontColor);i.fillText(e,o.x-measureText(e,t,i)/2,o.y+t/2);i.closePath();i.stroke()}}}a.chartData.mapData={bounds:l,scale:s,xoffset:u,yoffset:y,mercator:r.mercator};drawToolTipBridge(a,d,i,1);i.draw()}function normalInt(t,e,a){a=a==0?1:a;var i=[];for(var r=0;r<a;r++){i[r]=Math.random()}return Math.floor(i.reduce(function(t,e){return t+e})/a*(e-t))+t}function collisionNew(e,a,i,r){var o=false;for(let t=0;t<a.length;t++){if(a[t].area){if(e[3]<a[t].area[1]||e[0]>a[t].area[2]||e[1]>a[t].area[3]||e[2]<a[t].area[0]){if(e[0]<0||e[1]<0||e[2]>i||e[3]>r){o=true;break}else{o=false}}else{o=true;break}}}return o}function getWordCloudPoint(c,t,d){let x=c.series;switch(t){case"normal":for(let l=0;l<x.length;l++){let t=x[l].name;let e=x[l].textSize*c.pix;let a=measureText(t,e,d);let i,r;let o;let n=0;while(true){n++;i=normalInt(-c.width/2,c.width/2,5)-a/2;r=normalInt(-c.height/2,c.height/2,5)+e/2;o=[i-5+c.width/2,r-5-e+c.height/2,i+a+5+c.width/2,r+5+c.height/2];let t=collisionNew(o,x,c.width,c.height);if(!t)break;if(n==1e3){o=[-100,-100,-100,-100];break}}x[l].area=o}break;case"vertical":function f(){if(Math.random()>.7){return true}else{return false}};for(let h=0;h<x.length;h++){let t=x[h].name;let e=x[h].textSize*c.pix;let a=measureText(t,e,d);let i=f();let r,o,n,l;let s=0;while(true){s++;let t;if(i){r=normalInt(-c.width/2,c.width/2,5)-a/2;o=normalInt(-c.height/2,c.height/2,5)+e/2;n=[o-5-a+c.width/2,-r-5+c.height/2,o+5+c.width/2,-r+e+5+c.height/2];l=[c.width-(c.width/2-c.height/2)-(-r+e+5+c.height/2)-5,c.height/2-c.width/2+(o-5-a+c.width/2)-5,c.width-(c.width/2-c.height/2)-(-r+e+5+c.height/2)+e,c.height/2-c.width/2+(o-5-a+c.width/2)+a+5];t=collisionNew(l,x,c.height,c.width)}else{r=normalInt(-c.width/2,c.width/2,5)-a/2;o=normalInt(-c.height/2,c.height/2,5)+e/2;n=[r-5+c.width/2,o-5-e+c.height/2,r+a+5+c.width/2,o+5+c.height/2];t=collisionNew(n,x,c.width,c.height)}if(!t)break;if(s==1e3){n=[-1e3,-1e3,-1e3,-1e3];break}}if(i){x[h].area=l;x[h].areav=n}else{x[h].area=n}x[h].rotate=i};break}return x}function drawWordCloudDataPoints(t,r,e,o){let n=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;let a=assign({},{type:"normal",autoColors:true},r.extra.word);if(!r.chartData.wordCloudData){r.chartData.wordCloudData=getWordCloudPoint(r,a.type,o)}o.beginPath();o.setFillStyle(r.background);o.rect(0,0,r.width,r.height);o.fill();o.save();let l=r.chartData.wordCloudData;o.translate(r.width/2,r.height/2);for(let i=0;i<l.length;i++){o.save();if(l[i].rotate){o.rotate(90*Math.PI/180)}let t=l[i].name;let e=l[i].textSize*r.pix;let a=measureText(t,e,o);o.beginPath();o.setStrokeStyle(l[i].color);o.setFillStyle(l[i].color);o.setFontSize(e);if(l[i].rotate){if(l[i].areav[0]>0){if(r.tooltip){if(r.tooltip.index==i){o.strokeText(t,(l[i].areav[0]+5-r.width/2)*n-a*(1-n)/2,(l[i].areav[1]+5+e-r.height/2)*n)}else{o.fillText(t,(l[i].areav[0]+5-r.width/2)*n-a*(1-n)/2,(l[i].areav[1]+5+e-r.height/2)*n)}}else{o.fillText(t,(l[i].areav[0]+5-r.width/2)*n-a*(1-n)/2,(l[i].areav[1]+5+e-r.height/2)*n)}}}else{if(l[i].area[0]>0){if(r.tooltip){if(r.tooltip.index==i){o.strokeText(t,(l[i].area[0]+5-r.width/2)*n-a*(1-n)/2,(l[i].area[1]+5+e-r.height/2)*n)}else{o.fillText(t,(l[i].area[0]+5-r.width/2)*n-a*(1-n)/2,(l[i].area[1]+5+e-r.height/2)*n)}}else{o.fillText(t,(l[i].area[0]+5-r.width/2)*n-a*(1-n)/2,(l[i].area[1]+5+e-r.height/2)*n)}}}o.stroke();o.restore()}o.restore()}function drawFunnelDataPoints(e,a,t,i){let c=arguments.length>4&&arguments[4]!==undefined?arguments[4]:1;let r=assign({},{type:"funnel",activeWidth:10,activeOpacity:.3,border:false,borderWidth:2,borderColor:"#FFFFFF",fillOpacity:1,labelAlign:"right",linearType:"none",customColor:[]},a.extra.funnel);let o=(a.height-a.area[0]-a.area[2])/e.length;let n={x:a.area[3]+(a.width-a.area[1]-a.area[3])/2,y:a.height-a.area[2]};let l=r.activeWidth*a.pix;let d=Math.min((a.width-a.area[1]-a.area[3])/2-l,(a.height-a.area[0]-a.area[2])/2-l);e=getFunnelDataPoints(e,d,r.type,o,c);i.save();i.translate(n.x,n.y);r.customColor=fillCustomColor(r.linearType,r.customColor,e,t);if(r.type=="pyramid"){for(let t=0;t<e.length;t++){if(t==e.length-1){if(a.tooltip){if(a.tooltip.index==t){i.beginPath();i.setFillStyle(hexToRgb(e[t].color,r.activeOpacity));i.moveTo(-l,-o);i.lineTo(-e[t].radius-l,0);i.lineTo(e[t].radius+l,0);i.lineTo(l,-o);i.lineTo(-l,-o);i.closePath();i.fill()}}e[t].funnelArea=[n.x-e[t].radius,n.y-o*(t+1),n.x+e[t].radius,n.y-o*t];i.beginPath();i.setLineWidth(r.borderWidth*a.pix);i.setStrokeStyle(r.borderColor);var s=hexToRgb(e[t].color,r.fillOpacity);if(r.linearType=="custom"){var h=i.createLinearGradient(e[t].radius,-o,-e[t].radius,-o);h.addColorStop(0,hexToRgb(e[t].color,r.fillOpacity));h.addColorStop(.5,hexToRgb(r.customColor[e[t].linearIndex],r.fillOpacity));h.addColorStop(1,hexToRgb(e[t].color,r.fillOpacity));s=h}i.setFillStyle(s);i.moveTo(0,-o);i.lineTo(-e[t].radius,0);i.lineTo(e[t].radius,0);i.lineTo(0,-o);i.closePath();i.fill();if(r.border==true){i.stroke()}}else{if(a.tooltip){if(a.tooltip.index==t){i.beginPath();i.setFillStyle(hexToRgb(e[t].color,r.activeOpacity));i.moveTo(0,0);i.lineTo(-e[t].radius-l,0);i.lineTo(-e[t+1].radius-l,-o);i.lineTo(e[t+1].radius+l,-o);i.lineTo(e[t].radius+l,0);i.lineTo(0,0);i.closePath();i.fill()}}e[t].funnelArea=[n.x-e[t].radius,n.y-o*(t+1),n.x+e[t].radius,n.y-o*t];i.beginPath();i.setLineWidth(r.borderWidth*a.pix);i.setStrokeStyle(r.borderColor);var s=hexToRgb(e[t].color,r.fillOpacity);if(r.linearType=="custom"){var h=i.createLinearGradient(e[t].radius,-o,-e[t].radius,-o);h.addColorStop(0,hexToRgb(e[t].color,r.fillOpacity));h.addColorStop(.5,hexToRgb(r.customColor[e[t].linearIndex],r.fillOpacity));h.addColorStop(1,hexToRgb(e[t].color,r.fillOpacity));s=h}i.setFillStyle(s);i.moveTo(0,0);i.lineTo(-e[t].radius,0);i.lineTo(-e[t+1].radius,-o);i.lineTo(e[t+1].radius,-o);i.lineTo(e[t].radius,0);i.lineTo(0,0);i.closePath();i.fill();if(r.border==true){i.stroke()}}i.translate(0,-o)}}else{for(let t=0;t<e.length;t++){if(t==0){if(a.tooltip){if(a.tooltip.index==t){i.beginPath();i.setFillStyle(hexToRgb(e[t].color,r.activeOpacity));i.moveTo(-l,0);i.lineTo(-e[t].radius-l,-o);i.lineTo(e[t].radius+l,-o);i.lineTo(l,0);i.lineTo(-l,0);i.closePath();i.fill()}}e[t].funnelArea=[n.x-e[t].radius,n.y-o,n.x+e[t].radius,n.y];i.beginPath();i.setLineWidth(r.borderWidth*a.pix);i.setStrokeStyle(r.borderColor);var s=hexToRgb(e[t].color,r.fillOpacity);if(r.linearType=="custom"){var h=i.createLinearGradient(e[t].radius,-o,-e[t].radius,-o);h.addColorStop(0,hexToRgb(e[t].color,r.fillOpacity));h.addColorStop(.5,hexToRgb(r.customColor[e[t].linearIndex],r.fillOpacity));h.addColorStop(1,hexToRgb(e[t].color,r.fillOpacity));s=h}i.setFillStyle(s);i.moveTo(0,0);i.lineTo(-e[t].radius,-o);i.lineTo(e[t].radius,-o);i.lineTo(0,0);i.closePath();i.fill();if(r.border==true){i.stroke()}}else{if(a.tooltip){if(a.tooltip.index==t){i.beginPath();i.setFillStyle(hexToRgb(e[t].color,r.activeOpacity));i.moveTo(0,0);i.lineTo(-e[t-1].radius-l,0);i.lineTo(-e[t].radius-l,-o);i.lineTo(e[t].radius+l,-o);i.lineTo(e[t-1].radius+l,0);i.lineTo(0,0);i.closePath();i.fill()}}e[t].funnelArea=[n.x-e[t].radius,n.y-o*(t+1),n.x+e[t].radius,n.y-o*t];i.beginPath();i.setLineWidth(r.borderWidth*a.pix);i.setStrokeStyle(r.borderColor);var s=hexToRgb(e[t].color,r.fillOpacity);if(r.linearType=="custom"){var h=i.createLinearGradient(e[t].radius,-o,-e[t].radius,-o);h.addColorStop(0,hexToRgb(e[t].color,r.fillOpacity));h.addColorStop(.5,hexToRgb(r.customColor[e[t].linearIndex],r.fillOpacity));h.addColorStop(1,hexToRgb(e[t].color,r.fillOpacity));s=h}i.setFillStyle(s);i.moveTo(0,0);i.lineTo(-e[t-1].radius,0);i.lineTo(-e[t].radius,-o);i.lineTo(e[t].radius,-o);i.lineTo(e[t-1].radius,0);i.lineTo(0,0);i.closePath();i.fill();if(r.border==true){i.stroke()}}i.translate(0,-o)}}i.restore();if(a.dataLabel!==false&&c===1){drawFunnelText(e,a,i,o,r.labelAlign,l,n)}return{center:n,radius:d,series:e}}function drawFunnelText(l,s,h,c,d,x,f){for(let n=0;n<l.length;n++){let t=l[n];if(t.labelShow===false){continue}let e,a,i,r;let o=t.formatter?t.formatter(t,n,l,s):util.toFixed(t._proportion_*100)+"%";o=t.labelText?t.labelText:o;if(d=="right"){if(s.extra.funnel.type==="pyramid"){if(n==l.length-1){e=(t.funnelArea[2]+f.x)/2}else{e=(t.funnelArea[2]+l[n+1].funnelArea[2])/2}}else{if(n==0){e=(t.funnelArea[2]+f.x)/2}else{e=(t.funnelArea[2]+l[n-1].funnelArea[2])/2}}a=e+x*2;i=t.funnelArea[1]+c/2;r=t.textSize*s.pix||s.fontSize*s.pix;h.setLineWidth(1*s.pix);h.setStrokeStyle(t.color);h.setFillStyle(t.color);h.beginPath();h.moveTo(e,i);h.lineTo(a,i);h.stroke();h.closePath();h.beginPath();h.moveTo(a,i);h.arc(a,i,2*s.pix,0,2*Math.PI);h.closePath();h.fill();h.beginPath();h.setFontSize(r);h.setFillStyle(t.textColor||s.fontColor);h.fillText(o,a+5,i+r/2-2);h.closePath();h.stroke();h.closePath()}else{if(s.extra.funnel.type==="pyramid"){if(n==l.length-1){e=(t.funnelArea[0]+f.x)/2}else{e=(t.funnelArea[0]+l[n+1].funnelArea[0])/2}}else{if(n==0){e=(t.funnelArea[0]+f.x)/2}else{e=(t.funnelArea[0]+l[n-1].funnelArea[0])/2}}a=e-x*2;i=t.funnelArea[1]+c/2;r=t.textSize*s.pix||s.fontSize*s.pix;h.setLineWidth(1*s.pix);h.setStrokeStyle(t.color);h.setFillStyle(t.color);h.beginPath();h.moveTo(e,i);h.lineTo(a,i);h.stroke();h.closePath();h.beginPath();h.moveTo(a,i);h.arc(a,i,2,0,2*Math.PI);h.closePath();h.fill();h.beginPath();h.setFontSize(r);h.setFillStyle(t.textColor||s.fontColor);h.fillText(o,a-5-measureText(o,r,h),i+r/2-2);h.closePath();h.stroke();h.closePath()}}}function drawCanvas(t,e){e.draw()}var Timing={easeIn:function t(e){return Math.pow(e,3)},easeOut:function t(e){return Math.pow(e-1,3)+1},easeInOut:function t(e){if((e/=.5)<1){return.5*Math.pow(e,3)}else{return.5*(Math.pow(e-2,3)+2)}},linear:function t(e){return e}};function Animation(r){this.isStop=false;r.duration=typeof r.duration==="undefined"?1e3:r.duration;r.timing=r.timing||"easeInOut";var o=17;function t(){if(typeof setTimeout!=="undefined"){return function(e,t){setTimeout(function(){var t=+new Date;e(t)},t)}}else if(typeof requestAnimationFrame!=="undefined"){return requestAnimationFrame}else{return function(t){t(null)}}}var n=t();var l=null;var s=function t(e){if(e===null||this.isStop===true){r.onProcess&&r.onProcess(1);r.onAnimationFinish&&r.onAnimationFinish();return}if(l===null){l=e}if(e-l<r.duration){var a=(e-l)/r.duration;var i=Timing[r.timing];a=i(a);r.onProcess&&r.onProcess(a);n(s,o)}else{r.onProcess&&r.onProcess(1);r.onAnimationFinish&&r.onAnimationFinish()}};s=s.bind(this);n(s,o)}Animation.prototype.stop=function(){this.isStop=true};function drawCharts(t,l,n,s){var h=this;var c=l.series;if(t==="pie"||t==="ring"||t==="mount"||t==="rose"||t==="funnel"){c=fixPieSeries(c,l,n)}var d=l.categories;if(t==="mount"){d=[];for(let t=0;t<c.length;t++){if(c[t].show!==false)d.push(c[t].name)}l.categories=d}c=fillSeries(c,l,n);var e=l.animation?l.duration:0;h.animationInstance&&h.animationInstance.stop();var x=null;if(t=="candle"){let t=assign({},l.extra.candle.average);if(t.show){x=calCandleMA(t.day,t.name,t.color,c[0].data);x=fillSeries(x,l,n);l.seriesMA=x}else if(l.seriesMA){x=l.seriesMA=fillSeries(l.seriesMA,l,n)}else{x=c}}else{x=c}l._series_=c=filterSeries(c);l.area=new Array(4);for(let t=0;t<4;t++){l.area[t]=l.padding[t]*l.pix}var a=calLegendData(x,l,n,l.chartData,s),r=a.area.wholeHeight,o=a.area.wholeWidth;switch(l.legend.position){case"top":l.area[0]+=r;break;case"bottom":l.area[2]+=r;break;case"left":l.area[3]+=o;break;case"right":l.area[1]+=o;break}let f={},i=0;if(l.type==="line"||l.type==="column"||l.type==="mount"||l.type==="area"||l.type==="mix"||l.type==="candle"||l.type==="scatter"||l.type==="bubble"||l.type==="bar"){f=calYAxisData(c,l,n,s);i=f.yAxisWidth;if(l.yAxis.showTitle){let e=0;for(let t=0;t<l.yAxis.data.length;t++){e=Math.max(e,l.yAxis.data[t].titleFontSize?l.yAxis.data[t].titleFontSize*l.pix:n.fontSize)}l.area[0]+=e}let e=0,a=0;for(let t=0;t<i.length;t++){if(i[t].position=="left"){if(a>0){l.area[3]+=i[t].width+l.yAxis.padding*l.pix}else{l.area[3]+=i[t].width}a+=1}else if(i[t].position=="right"){if(e>0){l.area[1]+=i[t].width+l.yAxis.padding*l.pix}else{l.area[1]+=i[t].width}e+=1}}}else{n.yAxisWidth=i}l.chartData.yAxisData=f;if(l.categories&&l.categories.length&&l.type!=="radar"&&l.type!=="gauge"&&l.type!=="bar"){l.chartData.xAxisData=getXAxisPoints(l.categories,l,n);let t=calCategoriesData(l.categories,l,n,l.chartData.xAxisData.eachSpacing,s),e=t.xAxisHeight,a=t.angle;n.xAxisHeight=e;n._xAxisTextAngle_=a;l.area[2]+=e;l.chartData.categoriesData=t}else{if(l.type==="line"||l.type==="area"||l.type==="scatter"||l.type==="bubble"||l.type==="bar"){l.chartData.xAxisData=calXAxisData(c,l,n,s);d=l.chartData.xAxisData.rangesFormat;let t=calCategoriesData(d,l,n,l.chartData.xAxisData.eachSpacing,s),e=t.xAxisHeight,a=t.angle;n.xAxisHeight=e;n._xAxisTextAngle_=a;l.area[2]+=e;l.chartData.categoriesData=t}else{l.chartData.xAxisData={xAxisPoints:[]}}}if(l.enableScroll&&l.xAxis.scrollAlign=="right"&&l._scrollDistance_===undefined){let t=0,e=l.chartData.xAxisData.xAxisPoints,a=l.chartData.xAxisData.startX,i=l.chartData.xAxisData.endX,r=l.chartData.xAxisData.eachSpacing;let o=r*(e.length-1);let n=i-a;t=n-o;h.scrollOption.currentOffset=t;h.scrollOption.startTouchX=t;h.scrollOption.distance=0;h.scrollOption.lastMoveTime=0;l._scrollDistance_=t}if(t==="pie"||t==="ring"||t==="rose"){n._pieTextMaxLength_=l.dataLabel===false?0:getPieTextMaxLength(x,n,s,l)}switch(t){case"word":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function(t){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}drawWordCloudDataPoints(c,l,n,s,t);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"map":s.clearRect(0,0,l.width,l.height);drawMapDataPoints(c,l,n,s);break;case"funnel":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function(t){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}l.chartData.funnelData=drawFunnelDataPoints(c,l,n,s,t);drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,t);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"line":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}drawYAxisGrid(d,l,n,s);drawXAxis(d,l,n,s);var a=drawLineDataPoints(c,l,n,s,e),i=a.xAxisPoints,r=a.calPoints,o=a.eachSpacing;l.chartData.xAxisPoints=i;l.chartData.calPoints=r;l.chartData.eachSpacing=o;drawYAxis(c,l,n,s);if(l.enableMarkLine!==false&&e===1){drawMarkLine(l,n,s)}drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e,o,i);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"scatter":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}drawYAxisGrid(d,l,n,s);drawXAxis(d,l,n,s);var a=drawScatterDataPoints(c,l,n,s,e),i=a.xAxisPoints,r=a.calPoints,o=a.eachSpacing;l.chartData.xAxisPoints=i;l.chartData.calPoints=r;l.chartData.eachSpacing=o;drawYAxis(c,l,n,s);if(l.enableMarkLine!==false&&e===1){drawMarkLine(l,n,s)}drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e,o,i);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"bubble":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}drawYAxisGrid(d,l,n,s);drawXAxis(d,l,n,s);var a=drawBubbleDataPoints(c,l,n,s,e),i=a.xAxisPoints,r=a.calPoints,o=a.eachSpacing;l.chartData.xAxisPoints=i;l.chartData.calPoints=r;l.chartData.eachSpacing=o;drawYAxis(c,l,n,s);if(l.enableMarkLine!==false&&e===1){drawMarkLine(l,n,s)}drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e,o,i);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"mix":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}drawYAxisGrid(d,l,n,s);drawXAxis(d,l,n,s);var a=drawMixDataPoints(c,l,n,s,e),i=a.xAxisPoints,r=a.calPoints,o=a.eachSpacing;l.chartData.xAxisPoints=i;l.chartData.calPoints=r;l.chartData.eachSpacing=o;drawYAxis(c,l,n,s);if(l.enableMarkLine!==false&&e===1){drawMarkLine(l,n,s)}drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e,o,i);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"column":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}drawYAxisGrid(d,l,n,s);drawXAxis(d,l,n,s);var a=drawColumnDataPoints(c,l,n,s,e),i=a.xAxisPoints,r=a.calPoints,o=a.eachSpacing;l.chartData.xAxisPoints=i;l.chartData.calPoints=r;l.chartData.eachSpacing=o;drawYAxis(c,l,n,s);if(l.enableMarkLine!==false&&e===1){drawMarkLine(l,n,s)}drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e,o,i);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"mount":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}drawYAxisGrid(d,l,n,s);drawXAxis(d,l,n,s);var a=drawMountDataPoints(c,l,n,s,e),i=a.xAxisPoints,r=a.calPoints,o=a.eachSpacing;l.chartData.xAxisPoints=i;l.chartData.calPoints=r;l.chartData.eachSpacing=o;drawYAxis(c,l,n,s);if(l.enableMarkLine!==false&&e===1){drawMarkLine(l,n,s)}drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e,o,i);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"bar":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}drawXAxis(d,l,n,s);var a=drawBarDataPoints(c,l,n,s,e),i=a.yAxisPoints,r=a.calPoints,o=a.eachSpacing;l.chartData.yAxisPoints=i;l.chartData.xAxisPoints=l.chartData.xAxisData.xAxisPoints;l.chartData.calPoints=r;l.chartData.eachSpacing=o;drawYAxis(c,l,n,s);if(l.enableMarkLine!==false&&e===1){drawMarkLine(l,n,s)}drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e,o,i);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"area":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}drawYAxisGrid(d,l,n,s);drawXAxis(d,l,n,s);var a=drawAreaDataPoints(c,l,n,s,e),i=a.xAxisPoints,r=a.calPoints,o=a.eachSpacing;l.chartData.xAxisPoints=i;l.chartData.calPoints=r;l.chartData.eachSpacing=o;drawYAxis(c,l,n,s);if(l.enableMarkLine!==false&&e===1){drawMarkLine(l,n,s)}drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e,o,i);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"ring":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}l.chartData.pieData=drawPieDataPoints(c,l,n,s,e);drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"pie":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}l.chartData.pieData=drawPieDataPoints(c,l,n,s,e);drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"rose":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}l.chartData.pieData=drawRoseDataPoints(c,l,n,s,e);drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"radar":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}l.chartData.radarData=drawRadarDataPoints(c,l,n,s,e);drawLegend(l.series,l,n,s,l.chartData);drawToolTipBridge(l,n,s,e);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"arcbar":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}l.chartData.arcbarData=drawArcbarDataPoints(c,l,n,s,e);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"gauge":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}l.chartData.gaugeData=drawGaugeDataPoints(d,c,l,n,s,e);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break;case"candle":this.animationInstance=new Animation({timing:l.timing,duration:e,onProcess:function t(e){s.clearRect(0,0,l.width,l.height);if(l.rotate){contextRotate(s,l)}drawYAxisGrid(d,l,n,s);drawXAxis(d,l,n,s);var a=drawCandleDataPoints(c,x,l,n,s,e),i=a.xAxisPoints,r=a.calPoints,o=a.eachSpacing;l.chartData.xAxisPoints=i;l.chartData.calPoints=r;l.chartData.eachSpacing=o;drawYAxis(c,l,n,s);if(l.enableMarkLine!==false&&e===1){drawMarkLine(l,n,s)}if(x){drawLegend(x,l,n,s,l.chartData)}else{drawLegend(l.series,l,n,s,l.chartData)}drawToolTipBridge(l,n,s,e,o,i);drawCanvas(l,s)},onAnimationFinish:function t(){h.uevent.trigger("renderComplete")}});break}}function uChartsEvent(){this.events={}}uChartsEvent.prototype.addEventListener=function(t,e){this.events[t]=this.events[t]||[];this.events[t].push(e)};uChartsEvent.prototype.delEventListener=function(t){this.events[t]=[]};uChartsEvent.prototype.trigger=function(){for(var t=arguments.length,e=Array(t),a=0;a<t;a++){e[a]=arguments[a]}var i=e[0];var r=e.slice(1);if(!!this.events[i]){this.events[i].forEach(function(t){try{t.apply(null,r)}catch(t){}})}};var uCharts=function t(a){a.pix=a.pixelRatio?a.pixelRatio:1;a.fontSize=a.fontSize?a.fontSize:13;a.fontColor=a.fontColor?a.fontColor:config.fontColor;if(a.background==""||a.background=="none"){a.background="#FFFFFF"}a.title=assign({},a.title);a.subtitle=assign({},a.subtitle);a.duration=a.duration?a.duration:1e3;a.yAxis=assign({},{data:[],showTitle:false,disabled:false,disableGrid:false,splitNumber:5,gridType:"solid",dashLength:4*a.pix,gridColor:"#cccccc",padding:10,fontColor:"#666666"},a.yAxis);a.xAxis=assign({},{rotateLabel:false,rotateAngle:45,disabled:false,disableGrid:false,splitNumber:5,calibration:false,gridType:"solid",dashLength:4,scrollAlign:"left",boundaryGap:"center",axisLine:true,axisLineColor:"#cccccc"},a.xAxis);a.xAxis.scrollPosition=a.xAxis.scrollAlign;a.legend=assign({},{show:true,position:"bottom",float:"center",backgroundColor:"rgba(0,0,0,0)",borderColor:"rgba(0,0,0,0)",borderWidth:0,padding:5,margin:5,itemGap:10,fontSize:a.fontSize,lineHeight:a.fontSize,fontColor:a.fontColor,formatter:{},hiddenColor:"#CECECE"},a.legend);a.extra=assign({},a.extra);a.rotate=a.rotate?true:false;a.animation=a.animation?true:false;a.rotate=a.rotate?true:false;a.canvas2d=a.canvas2d?true:false;let e=assign({},config);e.color=a.color?a.color:e.color;if(a.type=="pie"){e.pieChartLinePadding=a.dataLabel===false?0:a.extra.pie.labelWidth*a.pix||e.pieChartLinePadding*a.pix}if(a.type=="ring"){e.pieChartLinePadding=a.dataLabel===false?0:a.extra.ring.labelWidth*a.pix||e.pieChartLinePadding*a.pix}if(a.type=="rose"){e.pieChartLinePadding=a.dataLabel===false?0:a.extra.rose.labelWidth*a.pix||e.pieChartLinePadding*a.pix}e.pieChartTextPadding=a.dataLabel===false?0:e.pieChartTextPadding*a.pix;e.rotate=a.rotate;if(a.rotate){let t=a.width;let e=a.height;a.width=e;a.height=t}a.padding=a.padding?a.padding:e.padding;e.yAxisWidth=config.yAxisWidth*a.pix;e.xAxisHeight=config.xAxisHeight*a.pix;if(a.enableScroll&&a.xAxis.scrollShow){e.xAxisHeight+=6*a.pix}e.fontSize=a.fontSize*a.pix;e.titleFontSize=config.titleFontSize*a.pix;e.subtitleFontSize=config.subtitleFontSize*a.pix;e.toolTipPadding=config.toolTipPadding*a.pix;e.toolTipLineHeight=config.toolTipLineHeight*a.pix;if(!a.context){throw new Error("[uCharts] 未获取到context！注意：v2.0版本后，需要自行获取canvas的绘图上下文并传入opts.context！")}this.context=a.context;if(!this.context.setTextAlign){this.context.setStrokeStyle=function(t){return this.strokeStyle=t};this.context.setLineWidth=function(t){return this.lineWidth=t};this.context.setLineCap=function(t){return this.lineCap=t};this.context.setFontSize=function(t){return this.font=t+"px sans-serif"};this.context.setFillStyle=function(t){return this.fillStyle=t};this.context.setTextAlign=function(t){return this.textAlign=t};this.context.draw=function(){}}if(!this.context.setLineDash){this.context.setLineDash=function(t){}}a.chartData={};this.uevent=new uChartsEvent;this.scrollOption={currentOffset:0,startTouchX:0,distance:0,lastMoveTime:0};this.opts=a;this.config=e;drawCharts.call(this,a.type,a,e,this.context)};uCharts.prototype.updateData=function(){let t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this.opts=assign({},this.opts,t);this.opts.updateData=true;let c=t.scrollPosition||"current";switch(c){case"current":this.opts._scrollDistance_=this.scrollOption.currentOffset;break;case"left":this.opts._scrollDistance_=0;this.scrollOption={currentOffset:0,startTouchX:0,distance:0,lastMoveTime:0};break;case"right":let t=calYAxisData(this.opts.series,this.opts,this.config,this.context),e=t.yAxisWidth;this.config.yAxisWidth=e;let a=0;let i=getXAxisPoints(this.opts.categories,this.opts,this.config),r=i.xAxisPoints,o=i.startX,n=i.endX,l=i.eachSpacing;let s=l*(r.length-1);let h=n-o;a=h-s;this.scrollOption={currentOffset:a,startTouchX:a,distance:0,lastMoveTime:0};this.opts._scrollDistance_=a;break}drawCharts.call(this,this.opts.type,this.opts,this.config,this.context)};uCharts.prototype.zoom=function(){var t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:this.opts.xAxis.itemCount;if(this.opts.enableScroll!==true){console.log("[uCharts] 请启用滚动条后使用");return}let e=Math.round(Math.abs(this.scrollOption.currentOffset)/this.opts.chartData.eachSpacing)+Math.round(this.opts.xAxis.itemCount/2);this.opts.animation=false;this.opts.xAxis.itemCount=t.itemCount;let a=calYAxisData(this.opts.series,this.opts,this.config,this.context),i=a.yAxisWidth;this.config.yAxisWidth=i;let r=0;let o=getXAxisPoints(this.opts.categories,this.opts,this.config),h=o.xAxisPoints,c=o.startX,d=o.endX,n=o.eachSpacing;let x=n*e;let l=d-c;let s=l-n*(h.length-1);r=l/2-x;if(r>0){r=0}if(r<s){r=s}this.scrollOption={currentOffset:r,startTouchX:0,distance:0,lastMoveTime:0};calValidDistance(this,r,this.opts.chartData,this.config,this.opts);this.opts._scrollDistance_=r;drawCharts.call(this,this.opts.type,this.opts,this.config,this.context)};uCharts.prototype.dobuleZoom=function(t){if(this.opts.enableScroll!==true){console.log("[uCharts] 请启用滚动条后使用");return}const a=t.changedTouches;if(a.length<2){return}for(var e=0;e<a.length;e++){a[e].x=a[e].x?a[e].x:a[e].clientX;a[e].y=a[e].y?a[e].y:a[e].clientY}const i=[getTouches(a[0],this.opts,t),getTouches(a[1],this.opts,t)];const c=Math.abs(i[0].x-i[1].x);if(!this.scrollOption.moveCount){let t={changedTouches:[{x:a[0].x,y:this.opts.area[0]/this.opts.pix+2}]};let e={changedTouches:[{x:a[1].x,y:this.opts.area[0]/this.opts.pix+2}]};if(this.opts.rotate){t={changedTouches:[{x:this.opts.height/this.opts.pix-this.opts.area[0]/this.opts.pix-2,y:a[0].y}]};e={changedTouches:[{x:this.opts.height/this.opts.pix-this.opts.area[0]/this.opts.pix-2,y:a[1].y}]}}const s=this.getCurrentDataIndex(t).index;const h=this.getCurrentDataIndex(e).index;const v=Math.abs(s-h);this.scrollOption.moveCount=v;this.scrollOption.moveCurrent1=Math.min(s,h);this.scrollOption.moveCurrent2=Math.max(s,h);return}let d=c/this.scrollOption.moveCount;let r=(this.opts.width-this.opts.area[1]-this.opts.area[3])/d;r=r<=2?2:r;r=r>=this.opts.categories.length?this.opts.categories.length:r;this.opts.animation=false;this.opts.xAxis.itemCount=r;let o=0;let n=getXAxisPoints(this.opts.categories,this.opts,this.config),x=n.xAxisPoints,f=n.startX,p=n.endX,l=n.eachSpacing;let g=l*this.scrollOption.moveCurrent1;let u=p-f;let y=u-l*(x.length-1);o=-g+Math.min(i[0].x,i[1].x)-this.opts.area[3]-l;if(o>0){o=0}if(o<y){o=y}this.scrollOption.currentOffset=o;this.scrollOption.startTouchX=0;this.scrollOption.distance=0;calValidDistance(this,o,this.opts.chartData,this.config,this.opts);this.opts._scrollDistance_=o;drawCharts.call(this,this.opts.type,this.opts,this.config,this.context)};uCharts.prototype.stopAnimation=function(){this.animationInstance&&this.animationInstance.stop()};uCharts.prototype.addEventListener=function(t,e){this.uevent.addEventListener(t,e)};uCharts.prototype.delEventListener=function(t){this.uevent.delEventListener(t)};uCharts.prototype.getCurrentDataIndex=function(e){var a=null;if(e.changedTouches){a=e.changedTouches[0]}else{a=e.mp.changedTouches[0]}if(a){let t=getTouches(a,this.opts,e);if(this.opts.type==="pie"||this.opts.type==="ring"){return findPieChartCurrentIndex({x:t.x,y:t.y},this.opts.chartData.pieData,this.opts)}else if(this.opts.type==="rose"){return findRoseChartCurrentIndex({x:t.x,y:t.y},this.opts.chartData.pieData,this.opts)}else if(this.opts.type==="radar"){return findRadarChartCurrentIndex({x:t.x,y:t.y},this.opts.chartData.radarData,this.opts.categories.length)}else if(this.opts.type==="funnel"){return findFunnelChartCurrentIndex({x:t.x,y:t.y},this.opts.chartData.funnelData)}else if(this.opts.type==="map"){return findMapChartCurrentIndex({x:t.x,y:t.y},this.opts)}else if(this.opts.type==="word"){return findWordChartCurrentIndex({x:t.x,y:t.y},this.opts.chartData.wordCloudData)}else if(this.opts.type==="bar"){return findBarChartCurrentIndex({x:t.x,y:t.y},this.opts.chartData.calPoints,this.opts,this.config,Math.abs(this.scrollOption.currentOffset))}else{return findCurrentIndex({x:t.x,y:t.y},this.opts.chartData.calPoints,this.opts,this.config,Math.abs(this.scrollOption.currentOffset))}}return-1};uCharts.prototype.getLegendDataIndex=function(e){var a=null;if(e.changedTouches){a=e.changedTouches[0]}else{a=e.mp.changedTouches[0]}if(a){let t=getTouches(a,this.opts,e);return findLegendIndex({x:t.x,y:t.y},this.opts.chartData.legendData)}return-1};uCharts.prototype.touchLegend=function(t){var e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var a=null;if(t.changedTouches){a=t.changedTouches[0]}else{a=t.mp.changedTouches[0]}if(a){var i=getTouches(a,this.opts,t);var r=this.getLegendDataIndex(t);if(r>=0){if(this.opts.type=="candle"){this.opts.seriesMA[r].show=!this.opts.seriesMA[r].show}else{this.opts.series[r].show=!this.opts.series[r].show}this.opts.animation=e.animation?true:false;this.opts._scrollDistance_=this.scrollOption.currentOffset;drawCharts.call(this,this.opts.type,this.opts,this.config,this.context)}}};uCharts.prototype.showToolTip=function(t){var e=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var c=null;if(t.changedTouches){c=t.changedTouches[0]}else{c=t.mp.changedTouches[0]}if(!c){console.log("[uCharts] 未获取到event坐标信息")}var a=getTouches(c,this.opts,t);var d=this.scrollOption.currentOffset;var i=assign({},this.opts,{_scrollDistance_:d,animation:false});if(this.opts.type==="line"||this.opts.type==="area"||this.opts.type==="column"||this.opts.type==="scatter"||this.opts.type==="bubble"){var r=this.getCurrentDataIndex(t);var o=e.index==undefined?r.index:e.index;if(o>-1||o.length>0){var n=getSeriesDataItem(this.opts.series,o,r.group);if(n.length!==0){var l=getToolTipData(n,this.opts,o,r.group,this.opts.categories,e),s=l.textList,h=l.offset;h.y=a.y;i.tooltip={textList:e.textList!==undefined?e.textList:s,offset:e.offset!==undefined?e.offset:h,option:e,index:o}}}drawCharts.call(this,i.type,i,this.config,this.context)}if(this.opts.type==="mount"){var o=e.index==undefined?this.getCurrentDataIndex(t).index:e.index;if(o>-1){var i=assign({},this.opts,{animation:false});var n=assign({},i._series_[o]);var s=[{text:e.formatter?e.formatter(n,undefined,o,i):n.name+": "+n.data,color:n.color}];var h={x:i.chartData.calPoints[o].x,y:a.y};i.tooltip={textList:e.textList?e.textList:s,offset:e.offset!==undefined?e.offset:h,option:e,index:o}}drawCharts.call(this,i.type,i,this.config,this.context)}if(this.opts.type==="bar"){var r=this.getCurrentDataIndex(t);var o=e.index==undefined?r.index:e.index;if(o>-1||o.length>0){var n=getSeriesDataItem(this.opts.series,o,r.group);if(n.length!==0){var l=getToolTipData(n,this.opts,o,r.group,this.opts.categories,e),s=l.textList,h=l.offset;h.x=a.x;i.tooltip={textList:e.textList!==undefined?e.textList:s,offset:e.offset!==undefined?e.offset:h,option:e,index:o}}}drawCharts.call(this,i.type,i,this.config,this.context)}if(this.opts.type==="mix"){var r=this.getCurrentDataIndex(t);var o=e.index==undefined?r.index:e.index;if(o>-1){var d=this.scrollOption.currentOffset;var i=assign({},this.opts,{_scrollDistance_:d,animation:false});var n=getSeriesDataItem(this.opts.series,o);if(n.length!==0){var x=getMixToolTipData(n,this.opts,o,this.opts.categories,e),s=x.textList,h=x.offset;h.y=a.y;i.tooltip={textList:e.textList?e.textList:s,offset:e.offset!==undefined?e.offset:h,option:e,index:o}}}drawCharts.call(this,i.type,i,this.config,this.context)}if(this.opts.type==="candle"){var r=this.getCurrentDataIndex(t);var o=e.index==undefined?r.index:e.index;if(o>-1){var d=this.scrollOption.currentOffset;var i=assign({},this.opts,{_scrollDistance_:d,animation:false});var n=getSeriesDataItem(this.opts.series,o);if(n.length!==0){var l=getCandleToolTipData(this.opts.series[0].data,n,this.opts,o,this.opts.categories,this.opts.extra.candle,e),s=l.textList,h=l.offset;h.y=a.y;i.tooltip={textList:e.textList?e.textList:s,offset:e.offset!==undefined?e.offset:h,option:e,index:o}}}drawCharts.call(this,i.type,i,this.config,this.context)}if(this.opts.type==="pie"||this.opts.type==="ring"||this.opts.type==="rose"||this.opts.type==="funnel"){var o=e.index==undefined?this.getCurrentDataIndex(t):e.index;if(o>-1){var i=assign({},this.opts,{animation:false});var n=assign({},i._series_[o]);var s=[{text:e.formatter?e.formatter(n,undefined,o,i):n.name+": "+n.data,color:n.color}];var h={x:a.x,y:a.y};i.tooltip={textList:e.textList?e.textList:s,offset:e.offset!==undefined?e.offset:h,option:e,index:o}}drawCharts.call(this,i.type,i,this.config,this.context)}if(this.opts.type==="map"){var o=e.index==undefined?this.getCurrentDataIndex(t):e.index;if(o>-1){var i=assign({},this.opts,{animation:false});var n=assign({},this.opts.series[o]);n.name=n.properties.name;var s=[{text:e.formatter?e.formatter(n,undefined,o,this.opts):n.name,color:n.color}];var h={x:a.x,y:a.y};i.tooltip={textList:e.textList?e.textList:s,offset:e.offset!==undefined?e.offset:h,option:e,index:o}}i.updateData=false;drawCharts.call(this,i.type,i,this.config,this.context)}if(this.opts.type==="word"){var o=e.index==undefined?this.getCurrentDataIndex(t):e.index;if(o>-1){var i=assign({},this.opts,{animation:false});var n=assign({},this.opts.series[o]);var s=[{text:e.formatter?e.formatter(n,undefined,o,this.opts):n.name,color:n.color}];var h={x:a.x,y:a.y};i.tooltip={textList:e.textList?e.textList:s,offset:e.offset!==undefined?e.offset:h,option:e,index:o}}i.updateData=false;drawCharts.call(this,i.type,i,this.config,this.context)}if(this.opts.type==="radar"){var o=e.index==undefined?this.getCurrentDataIndex(t):e.index;if(o>-1){var i=assign({},this.opts,{animation:false});var n=getSeriesDataItem(this.opts.series,o);if(n.length!==0){var s=n.map(t=>{return{text:e.formatter?e.formatter(t,this.opts.categories[o],o,this.opts):t.name+": "+t.data,color:t.color}});var h={x:a.x,y:a.y};i.tooltip={textList:e.textList?e.textList:s,offset:e.offset!==undefined?e.offset:h,option:e,index:o}}}drawCharts.call(this,i.type,i,this.config,this.context)}};uCharts.prototype.translate=function(t){this.scrollOption={currentOffset:t,startTouchX:t,distance:0,lastMoveTime:0};let e=assign({},this.opts,{_scrollDistance_:t,animation:false});drawCharts.call(this,this.opts.type,e,this.config,this.context)};uCharts.prototype.scrollStart=function(t){var e=null;if(t.changedTouches){e=t.changedTouches[0]}else{e=t.mp.changedTouches[0]}var a=getTouches(e,this.opts,t);if(e&&this.opts.enableScroll===true){this.scrollOption.startTouchX=a.x}};uCharts.prototype.scroll=function(t){if(this.scrollOption.lastMoveTime===0){this.scrollOption.lastMoveTime=Date.now()}let e=this.opts.touchMoveLimit||60;let a=Date.now();let i=a-this.scrollOption.lastMoveTime;if(i<Math.floor(1e3/e))return;if(this.scrollOption.startTouchX==0)return;this.scrollOption.lastMoveTime=a;var r=null;if(t.changedTouches){r=t.changedTouches[0]}else{r=t.mp.changedTouches[0]}if(r&&this.opts.enableScroll===true){var o=getTouches(r,this.opts,t);var n;n=o.x-this.scrollOption.startTouchX;var l=this.scrollOption.currentOffset;var s=calValidDistance(this,l+n,this.opts.chartData,this.config,this.opts);this.scrollOption.distance=n=s-l;var h=assign({},this.opts,{_scrollDistance_:l+n,animation:false});this.opts=h;drawCharts.call(this,h.type,h,this.config,this.context);return l+n}};uCharts.prototype.scrollEnd=function(t){if(this.opts.enableScroll===true){var e=this.scrollOption,a=e.currentOffset,i=e.distance;this.scrollOption.currentOffset=a+i;this.scrollOption.distance=0;this.scrollOption.moveCount=0}};export default uCharts;