//请求教育接口
let host = ''
if (process.env.NODE_ENV === "development") {
	host = 'http://192.168.10.36:8082/api'
	// host = 'http://192.168.10.65:8085/api'
} else {
	host = 'https://eduapi.oytour.com/api'
}
import Toast from '../wxcomponents/vant/toast/toast';
let request = (param) => {
	return new Promise((resolve, reject) => {
		let token = uni.getStorageSync('userInfo').Token;
		uni.request({
			url: host + param.url,
			method: param.method || "Post",
			header: param.header || {
				'content-type': "application/json",
				'Authorization': token || ""
			},
			data: {
				Msg: param.data,
			},
			success: res => {
				if (res.data.Code === 1) {
					resolve(res.data)
				} else {
					if (res.data.Message.indexOf('用户凭证为空') != -1 || res.data
						.Message.indexOf('用户凭证失效') != -1) {
						uni.showToast({
							title: "用户凭证失效,请重新授权",
							duration: 2000,
							icon: "none",
						});
						uni.removeStorageSync('userInfo');
						uni.reLaunch({
							url:"/pages/login/login"
						})
						reject()
					}else{
						uni.showToast({
							title: res.data.Message,
							duration: 2000,
							icon: "none",
							success() {
								if(res.data.Code === 0 && res.data.Data.Error==-1){//如果电话号码没有
									resolve(res.data)
								}else{
									reject()
								}
							}
						});
					}
					
				}
			},
			fail: (err) => {
				console.warn("fail:" + JSON.stringify(err));
				uni.showToast({
					title: '网络请求失败',
					duration: 2000,
					icon: "error",
				});
				reject()
			}
		});
	})
}
export default request
