import request from '../utils/request.js'

/**
 * 获取试卷列表
 * @param {JSON参数} data 
 */
export function getPaperList(data) {
    return request({
        //url: '/AppletIndex/GetGuestExaminationPublishPage_V2', 
        url: '/AppletIndex/GetGuestPublishPage_V2',
        method: 'post',
        data
    })
}

/**
 * 获取试卷详情
 * @param {JSON参数} data 
 */
export function getPaperDetail(data) {
    return request({
        url: '/appletindex/GetPaperDetails',
        method: 'post',
        data
    })
}

/**
 * 提交试卷
 * @param {JSON参数} data 
 */
export function submitPaper(data) {
    return request({
        url: '/AppletIndex/StuSubmitExamPaper',
        method: 'post',
        data
    })
}

/**
 * 记录考试时间
 * @param {JSON参数} data 
 */
export function SetStuExamStartTime(data) {
    return request({
        url: '/AppletIndex/SetStuExamStartTime',
        method: 'post',
        data
    })
}

/**
 * 查询考试数据
 * @param {JSON参数} data 
 */
export function queryQuestionPageList(data) {
    return request({
        url: '/Question/GetQuestionPageList',
        method: 'post',
        data
    })
}

/**
 * 获取阅读理解
 * @param {JSON参数} data 
 */
export function GetQuestionReading(data) {
    return request({
        url: '/Exam/GetQuestionReading',
        method: 'post',
        data
    })
}

/**
 * 获取等级评测
 * @param {JSON参数} data 
 */
export function GetBankTypeList(data) {
    return request({
        url: '/Question/GetBankTypeList',
        method: 'post',
        data
    })
}

/**
 * 获取问题数量
 * @param {JSON参数} data 
 */
export function GetAppQuestionStatic(data) {
    return request({
        url: '/Exam/GetAppQuestionStatic',
        method: 'post',
        data
    })
}

/**
 * 获取单词
 * @param {JSON参数} data 
 */
export function GetQuestionWords(data) {
    return request({
        url: '/Exam/GetQuestionWords',
        method: 'post',
        data
    })
}

/**
 * 获取语法
 * @param {JSON参数} data 
 */
export function GetQuestionGrammar(data) {
    return request({
        url: '/Exam/GetQuestionGrammar',
        method: 'post',
        data
    })
}

/**
 * 获取听力
 * @param {JSON参数} data 
 */
export function GetQuestionListening(data) {
    return request({
        url: '/Exam/GetQuestionListening',
        method: 'post',
        data
    })
}

/**
 * 点击答案提交答题
 * @param {JSON参数} data 
 */
export function SetStudentPractice(data) {
    return request({
        url: '/Exam/SetStudentPractice',
        method: 'post',
        data
    })
}

/**
 * 获取题库分类分页列表
 * @param {JSON参数} data 
 */
export function GetAppBankPage(data) {
    return request({
        url: '/Exam/GetAppBankPage',
        method: 'post',
        data
    })
}

/**
 * 获取题库详情列表
 * @param {JSON参数} data 
 */
export function GetAppBankDetails(data) {
    return request({
        url: '/Exam/GetAppBankDetails',
        method: 'post',
        data
    })
}

/**
 * 考试开始接口
 * @param {JSON参数} data 
 */
export function SetStudentStartExam(data) {
    return request({
        url: '/Exam/SetStudentStartExam',
        method: 'post',
        data
    })
}

/**
 * 保存考试接口
 * @param {JSON参数} data 
 */
export function SetStudentExam(data) {
    return request({
        url: '/Exam/SetStudentExam',
        method: 'post',
        data
    })
}

/**
 * 获取评测人数
 * @param {JSON参数} data 
 */
export function GetAppBankStatic(data) {
    return request({
        url: '/Exam/GetAppBankStatic',
        method: 'post',
        data
    })
}

/**
 * 获取错题数据
 * @param {JSON参数} data 
 */
export function GetPracticeWrongStatic(data) {
    return request({
        url: '/Exam/GetPracticeWrongStatic',
        method: 'post',
        data
    })
}

/**
 * 获取单词错题
 * @param {JSON参数} data 
 */
export function GetPracticeWrongPage(data) {
    return request({
        url: '/Exam/GetPracticeWrongPage',
        method: 'post',
        data
    })
}

/**
 * 设置错题已复习
 * @param {JSON参数} data 
 */
export function SetPracticeReview(data) {
    return request({
        url: '/Exam/SetPracticeReview',
        method: 'post',
        data
    })
}