function calcContentHeight(chaliang) {
	let contentHeight = 0
	uni.getSystemInfo({
		success(res) {
			contentHeight = res.windowHeight - 40 - chaliang
		}
	})
	return contentHeight
}
function SystemInfo() {//获取屏幕宽高
	let SystemInfo = {}
	uni.getSystemInfo({
		success(res) {
			SystemInfo.windowWidth = res.windowWidth
			SystemInfo.windowHeight = res.windowHeight
		}
	})
	return SystemInfo
}
function getRect(selector) {//获取元素的信息
	return new Promise((resolve) => {
		let view = uni.createSelectorQuery().select(selector);
		view.fields({
			size: true,
			rect: true,
			scrollOffset: true
		}, (res) => {
			resolve(res);
		}).exec();
	})
}
function getretailer() {//判断是否是分销商
	let isdistributor = false
	let mall_UserInfo = uni.getStorageSync("b2b_user");
	//mall_UserInfo.customerType (1-直客，2-同行)
	if (mall_UserInfo && mall_UserInfo.token && mall_UserInfo.customerType==2) {
		isdistributor = true
	}
	return isdistributor
}
// #ifdef MP-ALIPAY
// 引入消息模板方法   
const { requestSubscribeMessage } = requirePlugin("subscribeMsg");
//支付宝小程序订阅消息
function SubscribeMsgAli(cb) {
	let idsArr = uni.getStorageSync("basedata")?.mall?.alimessage ?? [];
	let ids = [];
	if (idsArr.length > 0) {
		idsArr.map((e) => {
			ids.push(e.MessageId);
		});
	}
	if (ids.length === 0) {
		my.showToast({
			type: 'fail',
			content: '请传入模板id',
			duration: 3000,
		});
		cb();
		return;
	}
	console.log('ids', ids);
	requestSubscribeMessage({ // 触发消息订阅弹框
		entityIds: ids, // 模板消息id，
		callback(res) {
			console.log('订阅回调', res);
			if (res.success) {
				uni.showToast({
					title: "订阅成功",
					duration: 1000,
				});
				cb();
			} else {
				switch (res.errorCode) {
					case 11: {
						my.call('toast', {
							content: '用户取消订阅',
						});
						break;
					}
					default: {
						my.call('toast', {
							content: `ErrorCode: ${res.errorCode}, ErrorMsg: ${res.errorMessage}`,
						});
						break;
					}
				}
				cb();
			}
		}
	})
}
// #endif
//定义更新方法
function VersionUpdate() {
	// 判断应用的 getUpdateManager 是否在当前版本可用
	if (uni.canIUse('getUpdateManager')) {
		const updateManager = uni.getUpdateManager()
		// 向小程序后台请求完新版本信息
		updateManager.onCheckForUpdate(function(res) {
			if (res.hasUpdate) {
				//小程序有新版本，静默下载新版本，新版本下载完成
				updateManager.onUpdateReady(function() {
					//模态弹窗（确认、取消）
					uni.showModal({
						title: '更新提示',
						content: '小程序已发布新版本，是否重启？',
						success: function(res) {
							//用户点击确定
							if (res.confirm) {
								//当新版本下载完成，调用该方法会强制当前小程序应用上新版本并重启
								updateManager.applyUpdate()
							} //用户点击取消
							else if (res.cancel) {
								//强制用户更新，弹出第二次弹窗
								uni.showModal({
									title: '提示',
									content: '小程序已发布新版本，是否重启',
									showCancel: false, //隐藏取消按钮
									success: function(res) {
										//第二次提示后，强制更新           
										if (res.confirm) {
											// 当新版本下载完成，调用该方法会强制当前小程序应用上新版本并重启
											updateManager.applyUpdate()
										}
									}
								})
							}
						}
					})
				})
				// 当新版本下载失败
				updateManager.onUpdateFailed(function() {
					uni.showModal({
						title: '提示',
						content: '请您删除当前小程序，重新打开小程序',
					})
				})
			}
		})
	} else {
		// 提示用户在最新版本的客户端上体验
		uni.showModal({
			title: '温馨提示',
			content: '当前微信版本过低，可能无法使用该功能，请升级到最新版本后重试。'
		})
	}
}

//方法二
function formatDates(date, fmt) {
    if (/(y+)/.test(fmt)) {
        fmt = fmt.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length));
    }
    let o = {
        'M+': date.getMonth() + 1,
        'd+': date.getDate(),
        'h+': date.getHours(),
        'm+': date.getMinutes(),
        's+': date.getSeconds()
    };
    for (let k in o) {
        if (new RegExp(`(${k})`).test(fmt)) {
            let str = o[k] + '';
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length === 1) ? str : padLeftZero(str));
        }
    }
    return fmt;
};
function padLeftZero(str) {
    return ('00' + str).substr(str.length);
}
function setAttatchParameter(vm){
	vm.$uiConfig.DIRECT_PARAMETER = ''
	if(uni.getStorageSync('b2b_user')){
		const {salesBaseInfo, erpBaseInfo} = uni.getStorageSync('b2b_user')
		if(erpBaseInfo && erpBaseInfo.employeeId){
			vm.$uiConfig.DIRECT_PARAMETER = '&direct_user_id='+erpBaseInfo.employeeId
		}else if(salesBaseInfo && salesBaseInfo.employeeId){
			vm.$uiConfig.DIRECT_PARAMETER = '&direct_user_id='+salesBaseInfo.employeeId
		}
	}
	
}
//获取几天后的日期
function GetDateFewFaysLater(Days){
	let today = new Date()
	let date2 = new Date(today); 
	
	const date = new Date(date2.setDate(today.getDate() + Days));

	// 获取日期信息
	const year = date.getFullYear();
	const month = date.getMonth() + 1; // 月份是从0开始的
	const day = date.getDate();
	return {
		year: year,
		month: month>9?month:'0'+month,
		mm:month,
		day: day>9?day:'0'+day,
		dd:day,
		date: `${year}-${month>9?month:'0'+month}-${day>9?day:'0'+day}`,
		hour:date.getHours(),
		minute:date.getMinutes(),
		second:date.getSeconds()
	}
}

function goZanYangUrl(){
		uni.navigateToMiniProgram({
			appId: 'wxacd9f8cc3480d29e',
			path: `pages/index/index?jzTravelOpenId=${uni.getStorageSync('mall_UserInfo').OpenId}`, // 目标页面路径（可选）
			extraData: { // 传递给目标小程序的数据（可选）
				
			},
		envVersion: 'release', // 目标版本（可选，默认 release；可选值：develop/trial/release）
		success(res) {
			console.log('跳转成功', res);
		},
		fail(err) {
			console.error('跳转失败', err);
		// 常见错误：-4（appId未声明）、-5（参数错误）、-100（用户拒绝）
		},
		complete() {
			console.log('跳转流程结束');
		}
	});
}

export default {
	calcContentHeight,
	SystemInfo,
	getRect,
	getretailer,
	// #ifdef MP-ALIPAY
	SubscribeMsgAli,
	// #endif
	VersionUpdate,
	formatDates,
	setAttatchParameter,
	GetDateFewFaysLater,
	goZanYangUrl
}