// 导入fs模块
const fs = require('fs')
const manifestPath = `${__dirname}/manifest.json`;
let Manifest = fs.readFileSync(manifestPath, {
	encoding: 'utf-8'
})

const ENV_CONFIG = {
	'mp-direct':{
		'appid':"wx5564525562e92ddb",
	},
	'mp-agent':{
		'appid':"wxcf0727a7c78b501e"
	}
}

function replaceManifest(path, value) {
	const arr = path.split('.')
	const len = arr.length
	const lastItem = arr[len - 1]

	let i = 0
	let ManifestArr = Manifest.split(/\n/)

	for (let index = 0; index < ManifestArr.length; index++) {
		const item = ManifestArr[index]
		if (new RegExp(`"${arr[i]}"`).test(item)) ++i
		if (i === len) {
			const hasComma = /,/.test(item)
			ManifestArr[index] = item.replace(
				new RegExp(`"${lastItem}"[\\s\\S]*:[\\s\\S]*`),
				`"${lastItem}": ${value}${hasComma ? ',' : ''}`
			)
			break
		}
	}

	Manifest = ManifestArr.join('\n')
}
// 读取环境变量内容
const appid =  ENV_CONFIG[process.env.UNI_SCRIPT].appid
console.log('新的APPID是：',appid,ENV_CONFIG)
if (appid) {
	replaceManifest('mp-weixin.appid', `"${appid}"`)
}

fs.writeFileSync(manifestPath, Manifest, {
	flag: 'w'
})