function calcContentHeight(chaliang) {
	let contentHeight = 0
	uni.getSystemInfo({
		success(res) {
			contentHeight = res.windowHeight - 40 - chaliang
		}
	})
	return contentHeight
}
function SystemInfo() {//获取屏幕宽高
	let SystemInfo = {}
	uni.getSystemInfo({
		success(res) {
			SystemInfo.windowWidth = res.windowWidth
			SystemInfo.windowHeight = res.windowHeight
		}
	})
	return SystemInfo
}
function getRect(selector) {//获取元素的信息
	return new Promise((resolve) => {
		let view = uni.createSelectorQuery().select(selector);
		view.fields({
			size: true,
			rect: true,
			scrollOffset: true
		}, (res) => {
			resolve(res);
		}).exec();
	})
}
function getretailer() {//判断是否是分销商
	let isdistributor = false
	let mall_UserInfo = uni.getStorageSync("b2b_user");
	//mall_UserInfo.customerType (1-直客，2-同行)
	if (mall_UserInfo && mall_UserInfo.token && mall_UserInfo.customerType==2) {
		isdistributor = true
	}
	return isdistributor
}
// #ifdef MP-ALIPAY
// 引入消息模板方法   
const { requestSubscribeMessage } = requirePlugin("subscribeMsg");
//支付宝小程序订阅消息
function SubscribeMsgAli(cb) {
	let idsArr = uni.getStorageSync("basedata")?.mall?.alimessage ?? [];
	let ids = [];
	if (idsArr.length > 0) {
		idsArr.map((e) => {
			ids.push(e.MessageId);
		});
	}
	if (ids.length === 0) {
		my.showToast({
			type: 'fail',
			content: '请传入模板id',
			duration: 3000,
		});
		cb();
		return;
	}
	console.log('ids', ids);
	requestSubscribeMessage({ // 触发消息订阅弹框
		entityIds: ids, // 模板消息id，
		callback(res) {
			console.log('订阅回调', res);
			if (res.success) {
				uni.showToast({
					title: "订阅成功",
					duration: 1000,
				});
				cb();
			} else {
				switch (res.errorCode) {
					case 11: {
						my.call('toast', {
							content: '用户取消订阅',
						});
						break;
					}
					default: {
						my.call('toast', {
							content: `ErrorCode: ${res.errorCode}, ErrorMsg: ${res.errorMessage}`,
						});
						break;
					}
				}
				cb();
			}
		}
	})
}
// #endif
//定义更新方法
function VersionUpdate() {
	// 判断应用的 getUpdateManager 是否在当前版本可用
	if (uni.canIUse('getUpdateManager')) {
		const updateManager = uni.getUpdateManager()
		// 向小程序后台请求完新版本信息
		updateManager.onCheckForUpdate(function(res) {
			if (res.hasUpdate) {
				//小程序有新版本，静默下载新版本，新版本下载完成
				updateManager.onUpdateReady(function() {
					//模态弹窗（确认、取消）
					uni.showModal({
						title: '更新提示',
						content: '小程序已发布新版本，是否重启？',
						success: function(res) {
							//用户点击确定
							if (res.confirm) {
								//当新版本下载完成，调用该方法会强制当前小程序应用上新版本并重启
								updateManager.applyUpdate()
							} //用户点击取消
							else if (res.cancel) {
								//强制用户更新，弹出第二次弹窗
								uni.showModal({
									title: '提示',
									content: '小程序已发布新版本，是否重启',
									showCancel: false, //隐藏取消按钮
									success: function(res) {
										//第二次提示后，强制更新           
										if (res.confirm) {
											// 当新版本下载完成，调用该方法会强制当前小程序应用上新版本并重启
											updateManager.applyUpdate()
										}
									}
								})
							}
						}
					})
				})
				// 当新版本下载失败
				updateManager.onUpdateFailed(function() {
					uni.showModal({
						title: '提示',
						content: '请您删除当前小程序，重新打开小程序',
					})
				})
			}
		})
	} else {
		// 提示用户在最新版本的客户端上体验
		uni.showModal({
			title: '温馨提示',
			content: '当前微信版本过低，可能无法使用该功能，请升级到最新版本后重试。'
		})
	}
}

//方法二
function formatDates(date, fmt) {
    if (/(y+)/.test(fmt)) {
        fmt = fmt.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length));
    }
    let o = {
        'M+': date.getMonth() + 1,
        'd+': date.getDate(),
        'h+': date.getHours(),
        'm+': date.getMinutes(),
        's+': date.getSeconds()
    };
    for (let k in o) {
        if (new RegExp(`(${k})`).test(fmt)) {
            let str = o[k] + '';
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length === 1) ? str : padLeftZero(str));
        }
    }
    return fmt;
};
function padLeftZero(str) {
    return ('00' + str).substr(str.length);
}
function setAttatchParameter(){
	this.$uiConfig.DIRECT_PARAMETER = ''
	if(uni.getStorageSync('b2b_user')){
		const {salesBaseInfo, erpBaseInfo} = uni.getStorageSync('b2b_user')
		if(erpBaseInfo && erpBaseInfo.employeeId){
			this.$uiConfig.DIRECT_PARAMETER = '&direct_user_id='+erpBaseInfo.employeeId
		}else if(salesBaseInfo && salesBaseInfo.employeeId){
			this.$uiConfig.DIRECT_PARAMETER = '&direct_user_id='+salesBaseInfo.employeeId
		}
	}
	
}
function changeMoneyToChinese(Num) { // 数字转中文大写
    if (!Num) {
      return '零'
    }
    var isNegative = false; // 是否负数
    if (Num < 0) {
      Num = -Num;
      isNegative = true;
    }
    if (typeof Num == 'number') {
      Num = Num.toString();
    }
    for (var i = Num.length - 1; i >= 0; i--) {
      Num = Num.replace(",", ""); // 替换money中的“,”
      Num = Num.replace(" ", ""); // 替换money中的空格
    }
    Num = Num.replace("￥", ""); // 替换掉可能出现的￥字符
    if (isNaN(Num)) { // 验证输入的字符是否为数字
      return;
    }
    // ---字符处理完毕，开始转换，转换采用前后两部分分别转换---//
    let part = String(Num).split(".");
    let newchar = "";
    // 小数点前进行转化
    for (var i = part[0].length - 1; i >= 0; i--) {
      if (part[0].length > 10) {
        // alertWarning("位数过大，无法计算");
        return "";
      } // 若数量超过拾亿单位，提示
      let tmpnewchar = "";
      let perchar = part[0].charAt(i);
      switch (perchar) {
        case "0":
          tmpnewchar = "零" + tmpnewchar;
          break;
        case "1":
          tmpnewchar = "壹" + tmpnewchar;
          break;
        case "2":
          tmpnewchar = "贰" + tmpnewchar;
          break;
        case "3":
          tmpnewchar = "叁" + tmpnewchar;
          break;
        case "4":
          tmpnewchar = "肆" + tmpnewchar;
          break;
        case "5":
          tmpnewchar = "伍" + tmpnewchar;
          break;
        case "6":
          tmpnewchar = "陆" + tmpnewchar;
          break;
        case "7":
          tmpnewchar = "柒" + tmpnewchar;
          break;
        case "8":
          tmpnewchar = "捌" + tmpnewchar;
          break;
        case "9":
          tmpnewchar = "玖" + tmpnewchar;
          break;
      }
      switch (part[0].length - i - 1) {
        case 0:
          tmpnewchar = tmpnewchar + "元";
          break;
        case 1:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "拾";
          break;
        case 2:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "佰";
          break;
        case 3:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "仟";
          break;
        case 4:
          tmpnewchar = tmpnewchar + "万";
          break;
        case 5:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "拾";
          break;
        case 6:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "佰";
          break;
        case 7:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "仟";
          break;
        case 8:
          tmpnewchar = tmpnewchar + "亿";
          break;
        case 9:
          tmpnewchar = tmpnewchar + "拾";
          break;
      }
      newchar = tmpnewchar + newchar;
    }
    // 小数点之后进行转化
    if (Num.indexOf(".") != -1) {
      if (part[1].length > 2) {
        // alertWarning("小数点之后只能保留两位,系统将自动截段");
        part[1] = part[1].substr(0, 2);
      }
      for (var i = 0; i < part[1].length; i++) {
        let tmpnewchar = "";
        let perchar = part[1].charAt(i);
        switch (perchar) {
          case "0":
            tmpnewchar = "零" + tmpnewchar;
            break;
          case "1":
            tmpnewchar = "壹" + tmpnewchar;
            break;
          case "2":
            tmpnewchar = "贰" + tmpnewchar;
            break;
          case "3":
            tmpnewchar = "叁" + tmpnewchar;
            break;
          case "4":
            tmpnewchar = "肆" + tmpnewchar;
            break;
          case "5":
            tmpnewchar = "伍" + tmpnewchar;
            break;
          case "6":
            tmpnewchar = "陆" + tmpnewchar;
            break;
          case "7":
            tmpnewchar = "柒" + tmpnewchar;
            break;
          case "8":
            tmpnewchar = "捌" + tmpnewchar;
            break;
          case "9":
            tmpnewchar = "玖" + tmpnewchar;
            break;
        }
        if (i == 0)
          tmpnewchar = tmpnewchar + "角";
        if (i == 1)
          tmpnewchar = tmpnewchar + "分";
        newchar = newchar + tmpnewchar;
      }
    }
    // 替换所有无用汉字
    while (newchar.search("零零") != -1)
    newchar = newchar.replace("零零", "零");
    newchar = newchar.replace("零亿", "亿");
    newchar = newchar.replace("亿万", "亿");
    newchar = newchar.replace("零万", "万");
    newchar = newchar.replace("零元", "");
    newchar = newchar.replace("零角", "");
    newchar = newchar.replace("零分", "");

    if (newchar.charAt(newchar.length - 1) == "元" || newchar.charAt(newchar.length - 1) == "角") {
      newchar = newchar + "整";
    }

    if (isNegative) {
      newchar = '负' + newchar;
    }

    return newchar;
}
export default {
	calcContentHeight,
	SystemInfo,
	getRect,
	getretailer,
	// #ifdef MP-ALIPAY
	SubscribeMsgAli,
	// #endif
	VersionUpdate,
	formatDates,
	changeMoneyToChinese,
	setAttatchParameter
}