import EnumHelper from "./enumhelper.js"
import ListProductTypeEnum from "./listProductType.js"

const ProductTypeEnum = [{
		value: 1,
		desc: '机票产品'
	},
	/**
	 * 线路
	 */
	{
		value: 2,
		desc: '线路产品'
	},

	/**
	 * 酒店
	 */
	{
		value: 3,
		desc: '酒店产品'
	},

	/**
	 * 景点门票
	 */
	{
		value: 4,
		desc: '景点门票产品'
	},

	/**
	 * 包车
	 */
	{
		value: 5,
		desc: '包车产品'
	},
	{
		value: 6,
		desc: '签证产品'
	},
	{
		value: 7,
		desc: '酒店产品'
	},
]

const mappingRules = [
	[-1],
	[1, 2, 3],
	[4, 5, 6, 7],
	[-1],
	[12, 13, 14],
	[8, 9, 10, 11],
	[15],
	[16]
]

const mappingListType = (value) => {
	let val = mappingRules.findIndex(x => {
		return x.indexOf(value) != -1
	})

	if (val && val > 0) {
		return EnumHelper.ParseToEnum(ListProductTypeEnum, val, 'value')
	}
	return {}
}

const mappingListTypeTy = (type) => {
	let val = ProductTypeEnum.findIndex(x => {
		return x.value == Number(type)
	})
	return ProductTypeEnum[val]
}

const transProductEnum = (value) => {
	return mappingRules[value]
}

export default ProductTypeEnum

export {
	mappingListType,
	transProductEnum,
	mappingListTypeTy
}